/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.UniRepeat;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.shaded.io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.subscription.UniEmitter;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class MultiRepetition {
    @CheckReturnValue
    public <S, T> UniRepeat<T> uni(Supplier<S> stateSupplier, Function<S, Uni<? extends T>> producer) {
        Uni<? extends T> upstream = Uni.createFrom().deferred(stateSupplier, producer);
        return new UniRepeat<T>(upstream);
    }

    @CheckReturnValue
    public <T> UniRepeat<T> uni(Supplier<Uni<? extends T>> uniSupplier) {
        Uni<? extends T> upstream = Uni.createFrom().deferred(uniSupplier);
        return new UniRepeat<T>(upstream);
    }

    @CheckReturnValue
    public <S, T> UniRepeat<T> completionStage(Supplier<S> stateSupplier, Function<S, ? extends CompletionStage<? extends T>> producer) {
        Function actual = Infrastructure.decorate(ParameterValidation.nonNull(producer, "producer"));
        return this.uni(stateSupplier, (S s) -> Uni.createFrom().completionStage((CompletionStage)actual.apply(s)));
    }

    @CheckReturnValue
    public <T> UniRepeat<T> completionStage(Supplier<? extends CompletionStage<? extends T>> supplier) {
        ParameterValidation.nonNull(supplier, "supplier");
        return this.uni(() -> Uni.createFrom().completionStage(supplier));
    }

    @CheckReturnValue
    public <S, T> UniRepeat<T> uni(Supplier<S> stateSupplier, BiConsumer<S, UniEmitter<? super T>> consumer) {
        BiConsumer actual = Infrastructure.decorate(ParameterValidation.nonNull(consumer, "consumer"));
        return this.uni(stateSupplier, (S s) -> Uni.createFrom().emitter(e -> actual.accept((Object)s, (UniEmitter)e)));
    }

    @CheckReturnValue
    public <T> UniRepeat<T> uni(Consumer<UniEmitter<? super T>> consumer) {
        Consumer actual = Infrastructure.decorate(ParameterValidation.nonNull(consumer, "consumer"));
        return this.uni(() -> Uni.createFrom().emitter(actual));
    }

    @CheckReturnValue
    public <T> UniRepeat<T> supplier(Supplier<? extends T> supplier) {
        return new UniRepeat<Supplier<? extends T>>(Uni.createFrom().item(supplier));
    }

    @CheckReturnValue
    public <S, T> UniRepeat<T> supplier(Supplier<S> stateSupplier, Function<S, ? extends T> producer) {
        return this.uni(stateSupplier, (S s) -> Uni.createFrom().item(() -> producer.apply(s)));
    }
}

