/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.overflow.MultiOnOverflowBufferOp;
import io.smallrye.mutiny.operators.multi.overflow.MultiOnOverflowDropItemsOp;
import io.smallrye.mutiny.operators.multi.overflow.MultiOnOverflowKeepLastOp;
import io.smallrye.mutiny.shaded.io.smallrye.common.annotation.CheckReturnValue;
import java.util.function.Consumer;
import java.util.function.Function;

public class MultiOverflowStrategy<T> {
    private final Multi<T> upstream;
    private final Consumer<T> dropConsumer;
    private final Function<T, Uni<?>> dropUniMapper;

    public MultiOverflowStrategy(Multi<T> upstream, Consumer<T> dropConsumer, Function<T, Uni<?>> dropUniMapper) {
        this.upstream = upstream;
        this.dropConsumer = dropConsumer;
        this.dropUniMapper = dropUniMapper;
    }

    @CheckReturnValue
    public Multi<T> drop() {
        return Infrastructure.onMultiCreation(new MultiOnOverflowDropItemsOp<T>(this.upstream, this.dropConsumer, this.dropUniMapper));
    }

    @CheckReturnValue
    public Multi<T> buffer() {
        return this.buffer(Infrastructure.getMultiOverflowDefaultBufferSize());
    }

    @CheckReturnValue
    public Multi<T> buffer(int size) {
        return Infrastructure.onMultiCreation(new MultiOnOverflowBufferOp<T>(this.upstream, ParameterValidation.positive(size, "size"), false, this.dropConsumer, this.dropUniMapper));
    }

    @CheckReturnValue
    public Multi<T> bufferUnconditionally() {
        return Infrastructure.onMultiCreation(new MultiOnOverflowBufferOp<T>(this.upstream, Infrastructure.getMultiOverflowDefaultBufferSize(), true, this.dropConsumer, this.dropUniMapper));
    }

    @CheckReturnValue
    public Multi<T> dropPreviousItems() {
        return Infrastructure.onMultiCreation(new MultiOnOverflowKeepLastOp<T>(this.upstream, this.dropConsumer, this.dropUniMapper));
    }
}

