/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.groups.MultiItemCombineIterable;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.shaded.io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.tuples.Functions;
import io.smallrye.mutiny.tuples.Tuple6;
import java.util.concurrent.Flow;

public class MultiItemCombine6<T1, T2, T3, T4, T5, T6>
extends MultiItemCombineIterable {
    public MultiItemCombine6(Iterable<Flow.Publisher<?>> iterable) {
        super(iterable);
    }

    @Override
    @CheckReturnValue
    public MultiItemCombine6<T1, T2, T3, T4, T5, T6> collectFailures() {
        super.collectFailures();
        return this;
    }

    @Override
    @CheckReturnValue
    public MultiItemCombine6<T1, T2, T3, T4, T5, T6> latestItems() {
        super.latestItems();
        return this;
    }

    @CheckReturnValue
    public Multi<Tuple6<T1, T2, T3, T4, T5, T6>> asTuple() {
        return this.using(Tuple6::of);
    }

    @CheckReturnValue
    public <O> Multi<O> using(Functions.Function6<T1, T2, T3, T4, T5, T6, O> combinator) {
        ParameterValidation.nonNull(combinator, "combinator");
        return super.combine(args -> {
            ParameterValidation.size(args, 6, "args");
            return combinator.apply(args.get(0), args.get(1), args.get(2), args.get(3), args.get(4), args.get(5));
        });
    }
}

