/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.MultiBufferOp;
import io.smallrye.mutiny.operators.multi.MultiBufferWithTimeoutOp;
import io.smallrye.mutiny.shaded.io.smallrye.common.annotation.CheckReturnValue;
import java.time.Duration;
import java.util.List;

public class MultiGroupIntoLists<T> {
    private final Multi<T> upstream;

    public MultiGroupIntoLists(Multi<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    @CheckReturnValue
    public Multi<List<T>> every(Duration duration) {
        return Infrastructure.onMultiCreation(new MultiBufferWithTimeoutOp<T>(this.upstream, Integer.MAX_VALUE, ParameterValidation.validate(duration, "duration"), Infrastructure.getDefaultWorkerPool(), false));
    }

    @CheckReturnValue
    public Multi<List<T>> every(Duration duration, boolean emitEmptyListIfNoItems) {
        return Infrastructure.onMultiCreation(new MultiBufferWithTimeoutOp<T>(this.upstream, Integer.MAX_VALUE, ParameterValidation.validate(duration, "duration"), Infrastructure.getDefaultWorkerPool(), emitEmptyListIfNoItems));
    }

    @CheckReturnValue
    public Multi<List<T>> of(int size) {
        return Infrastructure.onMultiCreation(new MultiBufferOp<T>(this.upstream, size, size));
    }

    @CheckReturnValue
    public Multi<List<T>> of(int size, int skip) {
        return Infrastructure.onMultiCreation(new MultiBufferOp<T>(this.upstream, ParameterValidation.positive(size, "size"), ParameterValidation.positive(skip, "skip")));
    }

    @CheckReturnValue
    public Multi<List<T>> of(int size, Duration maximumDelay) {
        return Infrastructure.onMultiCreation(new MultiBufferWithTimeoutOp<T>(this.upstream, ParameterValidation.positive(size, "size"), ParameterValidation.validate(maximumDelay, "maximumDelay"), Infrastructure.getDefaultWorkerPool(), false));
    }
}

