/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.shaded.io.smallrye.common.annotation.CheckReturnValue;
import java.util.concurrent.Flow;
import java.util.function.Function;

public class MultiConvert<T> {
    private final Multi<T> upstream;

    public MultiConvert(Multi<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public <R> R with(Function<Multi<T>, R> converter) {
        ParameterValidation.nonNull(converter, "converter");
        return converter.apply(this.upstream);
    }

    @CheckReturnValue
    public Flow.Publisher<T> toPublisher() {
        return this.upstream;
    }
}

