/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.util.Arrays;
import java.util.List;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.ImmutableArrayList;
import org.jboss.jandex.Interned;
import org.jboss.jandex.Type;

public class ParameterizedType
extends Type {
    private final Type[] arguments;
    private final Type owner;
    private int hash;

    public static ParameterizedType create(DotName name, Type[] arguments, Type owner) {
        return new ParameterizedType(name, arguments, owner);
    }

    ParameterizedType(DotName name, Type[] arguments, Type owner) {
        this(name, arguments, owner, null);
    }

    ParameterizedType(DotName name, Type[] arguments, Type owner, AnnotationInstance[] annotations) {
        super(name, annotations);
        this.arguments = arguments == null ? EMPTY_ARRAY : arguments;
        this.owner = owner;
    }

    public List<Type> arguments() {
        return new ImmutableArrayList<Type>(this.arguments);
    }

    Type[] argumentsArray() {
        return this.arguments;
    }

    public Type owner() {
        return this.owner;
    }

    @Override
    public Type.Kind kind() {
        return Type.Kind.PARAMETERIZED_TYPE;
    }

    @Override
    public ParameterizedType asParameterizedType() {
        return this;
    }

    @Override
    ParameterizedType copyType(AnnotationInstance[] newAnnotations) {
        return new ParameterizedType(this.name(), this.arguments, this.owner, newAnnotations);
    }

    ParameterizedType copyType(Type[] arguments) {
        return new ParameterizedType(this.name(), arguments, this.owner, this.annotationArray());
    }

    ParameterizedType copyType(int argumentIndex, Type argument) {
        if (argumentIndex > this.arguments.length) {
            throw new IllegalArgumentException("Type argument index outside of bounds");
        }
        Type[] arguments = (Type[])this.arguments.clone();
        arguments[argumentIndex] = argument;
        return new ParameterizedType(this.name(), arguments, this.owner, this.annotationArray());
    }

    ParameterizedType copyType(Type owner) {
        return new ParameterizedType(this.name(), this.arguments, owner, this.annotationArray());
    }

    @Override
    String toString(boolean simple) {
        StringBuilder builder = new StringBuilder();
        if (this.owner != null) {
            builder.append(this.owner);
            builder.append('.');
            this.appendAnnotations(builder);
            builder.append(this.name().local());
        } else {
            String packagePrefix = this.name().packagePrefix();
            if (packagePrefix != null) {
                builder.append(packagePrefix).append('.');
            }
            this.appendAnnotations(builder);
            builder.append(this.name().withoutPackagePrefix());
        }
        if (this.arguments.length > 0) {
            builder.append('<');
            builder.append(this.arguments[0].toString(true));
            for (int i = 1; i < this.arguments.length; ++i) {
                builder.append(", ").append(this.arguments[i].toString(true));
            }
            builder.append('>');
        }
        return builder.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParameterizedType other = (ParameterizedType)o;
        return (this.owner == other.owner || this.owner != null && this.owner.equals(other.owner)) && Arrays.equals(this.arguments, other.arguments);
    }

    @Override
    public int hashCode() {
        int hash = this.hash;
        if (hash != 0) {
            return hash;
        }
        hash = super.hashCode();
        hash = 31 * hash + Arrays.hashCode(this.arguments);
        this.hash = hash = 31 * hash + (this.owner != null ? this.owner.hashCode() : 0);
        return this.hash;
    }

    @Override
    public boolean internEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.internEquals(o)) {
            return false;
        }
        ParameterizedType other = (ParameterizedType)o;
        return (this.owner == other.owner || this.owner != null && this.owner.internEquals(other.owner)) && Interned.arrayEquals(this.arguments, other.arguments);
    }

    @Override
    public int internHashCode() {
        int hash = super.internHashCode();
        hash = 31 * hash + Interned.arrayHashCode(this.arguments);
        hash = 31 * hash + (this.owner != null ? this.owner.internHashCode() : 0);
        return hash;
    }
}

