/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.util.injection;

import io.smallrye.config.util.injection.ConfigSourceMap;
import io.smallrye.config.util.injection.Name;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigSource;

@Dependent
public class ConfigSourceProvider {
    @Inject
    private Provider<Config> configProvider;
    private final Map<String, ConfigSource> configSourceMap = new HashMap<String, ConfigSource>(){

        @Override
        public Collection<ConfigSource> values() {
            return StreamSupport.stream(((Config)ConfigSourceProvider.this.configProvider.get()).getConfigSources().spliterator(), false).collect(Collectors.toList());
        }
    };

    @PostConstruct
    public void init() {
        if (this.configSourceMap.isEmpty()) {
            for (ConfigSource configSource : ((Config)this.configProvider.get()).getConfigSources()) {
                this.configSourceMap.put(configSource.getName(), configSource);
            }
        }
    }

    @Produces
    @ConfigSourceMap
    public Map<String, ConfigSource> produceConfigSourceMap() {
        return this.configSourceMap;
    }

    @Produces
    @Name(value="")
    public ConfigSource produceConfigSource(InjectionPoint injectionPoint) {
        Set qualifiers = injectionPoint.getQualifiers();
        String name = this.getName(qualifiers);
        return this.configSourceMap.get(name);
    }

    private String getName(Set<Annotation> qualifiers) {
        for (Annotation qualifier : qualifiers) {
            if (!qualifier.annotationType().equals(Name.class)) continue;
            Name name = (Name)qualifier;
            return name.value();
        }
        return "";
    }
}

