/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.jasypt;

import io.smallrye.config.ConfigMessages;
import io.smallrye.config.ConfigSourceContext;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.SecretKeysHandler;
import io.smallrye.config.SecretKeysHandlerFactory;
import io.smallrye.config.jasypt.JasyptSecretKeysHandler;
import java.util.NoSuchElementException;

public class JasyptSecretKeysHandlerFactory
implements SecretKeysHandlerFactory {
    public SecretKeysHandler getSecretKeysHandler(ConfigSourceContext context) {
        String password = JasyptSecretKeysHandlerFactory.requireValue(context, "smallrye.config.secret-handler.jasypt.password");
        String algorithm = JasyptSecretKeysHandlerFactory.requireValue(context, "smallrye.config.secret-handler.jasypt.algorithm");
        return new JasyptSecretKeysHandler(password, algorithm);
    }

    public String getName() {
        return "jasypt";
    }

    private static String requireValue(ConfigSourceContext context, String name) {
        ConfigValue value = context.getValue(name);
        if (value != null) {
            return value.getValue();
        }
        throw new NoSuchElementException(ConfigMessages.msg.propertyNotFound(name));
    }
}

