/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.version;

import io.smallrye.common.version.AbstractVersionIterator;
import io.smallrye.common.version.AbstractVersionScheme;
import io.smallrye.common.version.MavenVersionIterator;

final class MavenVersionScheme
extends AbstractVersionScheme<MavenVersionIterator> {
    MavenVersionScheme() {
    }

    @Override
    public MavenVersionIterator iterate(String version) {
        return new MavenVersionIterator(version);
    }

    @Override
    protected int compareNext(MavenVersionIterator i1, MavenVersionIterator i2) {
        if (!i1.hasNext()) {
            if (!i2.hasNext()) {
                return 0;
            }
            i2.next();
            return -this.compareZero(i2);
        }
        if (!i2.hasNext()) {
            i1.next();
            return this.compareZero(i1);
        }
        i1.next();
        i2.next();
        return this.compare(i1, i2);
    }

    @Override
    protected int compareZero(MavenVersionIterator i) {
        int m;
        if (!i.hasNext()) {
            return 0;
        }
        i.next();
        if (i.isSeparator()) {
            i.insertEmptyAlpha();
        }
        if ((m = i.getMilestoneMagnitude()) != -1) {
            int res = Integer.compare(m, 5);
            if (res != 0) {
                return res;
            }
            if (i.hasNext()) {
                i.next();
                return this.compareZero(i);
            }
            return 0;
        }
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected int compare(MavenVersionIterator i1, MavenVersionIterator i2) {
        AbstractVersionIterator.TokenType p2;
        AbstractVersionIterator.TokenType p1;
        block20: {
            if (i1.isSeparator()) {
                i1.insertEmptyAlpha();
            }
            if (i2.isSeparator()) {
                i2.insertEmptyAlpha();
            }
            int m1 = i1.getMilestoneMagnitude();
            int m2 = i2.getMilestoneMagnitude();
            if (m1 != -1) {
                if (m2 == -1) {
                    return -1;
                }
                int res = Integer.compare(m1, m2);
                if (res != 0) {
                    return res;
                }
            } else if (m2 != -1) {
                return 1;
            }
            p1 = i1.currentType();
            p2 = i2.currentType();
            if (p1 == AbstractVersionIterator.TokenType.PART_ALPHA) {
                if (p2 == AbstractVersionIterator.TokenType.PART_ALPHA) {
                    int res = i1.compareAlphaPart(i2, true);
                    if (res != 0) {
                        return res;
                    }
                    break block20;
                } else {
                    assert (p2 == AbstractVersionIterator.TokenType.PART_NUMBER);
                    return -1;
                }
            }
            if (p2 == AbstractVersionIterator.TokenType.PART_ALPHA) {
                assert (p1 == AbstractVersionIterator.TokenType.PART_NUMBER);
                return 1;
            }
            assert (p1 == AbstractVersionIterator.TokenType.PART_NUMBER && p2 == AbstractVersionIterator.TokenType.PART_NUMBER);
            int res = i1.compareNumberPart(i2);
            if (res != 0) {
                return res;
            }
        }
        assert (p2 == p1);
        if (i1.hasNext()) {
            i1.next();
            if (i2.hasNext()) {
                i2.next();
                return this.compareNext(i1, i2);
            }
            return this.compareZero(i1);
        }
        if (i2.hasNext()) {
            i2.next();
            return -this.compareZero(i2);
        }
        return 0;
    }
}

