/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.version;

import io.smallrye.common.version.AbstractVersionIterator;
import io.smallrye.common.version.AbstractVersionScheme;
import io.smallrye.common.version.MavenVersionIterator;

final class MavenVersionScheme
extends AbstractVersionScheme<MavenVersionIterator> {
    MavenVersionScheme() {
    }

    @Override
    public MavenVersionIterator iterate(String version) {
        return new MavenVersionIterator(version);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected int compare(MavenVersionIterator i1, MavenVersionIterator i2) {
        int res;
        if (i1.isSeparator()) {
            i1.insertEmptyAlpha();
        }
        if (i2.isSeparator()) {
            i2.insertEmptyAlpha();
        }
        int m1 = i1.getMilestoneMagnitude();
        int m2 = i2.getMilestoneMagnitude();
        if (m1 != -1) {
            if (m2 == -1) return -1;
            int res2 = Integer.compare(m1, m2);
            if (res2 != 0) {
                return res2;
            }
        } else if (m2 != -1) {
            return 1;
        }
        AbstractVersionIterator.TokenType p1 = i1.currentType();
        AbstractVersionIterator.TokenType p2 = i2.currentType();
        if (p1 == AbstractVersionIterator.TokenType.PART_ALPHA) {
            if (p2 != AbstractVersionIterator.TokenType.PART_ALPHA) {
                if ($assertionsDisabled) return -1;
                if (p2 == AbstractVersionIterator.TokenType.PART_NUMBER) return -1;
                throw new AssertionError();
            }
            res = i1.compareAlphaPart(i2, true);
            if (res != 0) {
                return res;
            }
        } else {
            if (p2 == AbstractVersionIterator.TokenType.PART_ALPHA) {
                if ($assertionsDisabled) return 1;
                if (p1 == AbstractVersionIterator.TokenType.PART_NUMBER) return 1;
                throw new AssertionError();
            }
            if (!$assertionsDisabled) {
                if (p1 != AbstractVersionIterator.TokenType.PART_NUMBER) throw new AssertionError();
                if (p2 != AbstractVersionIterator.TokenType.PART_NUMBER) {
                    throw new AssertionError();
                }
            }
            if ((res = i1.compareNumberPart(i2)) != 0) {
                return res;
            }
        }
        assert (p2 == p1);
        if (!i1.hasNext()) {
            if (i2.hasNext()) return -1;
            return 0;
        }
        if (!i2.hasNext()) {
            return 1;
        }
        boolean z1 = i1.isZeroSegment();
        boolean z2 = i2.isZeroSegment();
        i1.next();
        i2.next();
        int s1 = i1.getSeparatorCodePoint();
        int s2 = i2.getSeparatorCodePoint();
        assert (s1 == 45 || s1 == 46);
        assert (s2 == 45 || s2 == 46);
        if (s1 == s2) {
            return this.compareNext(i1, i2);
        }
        if (s1 == 45) {
            assert (s2 == 46);
            i2.next();
            if (p2 != AbstractVersionIterator.TokenType.PART_ALPHA) {
                if (z2) return -1;
            }
            i1.insertEmptyNumber();
            return this.compare(i1, i2);
        }
        assert (s1 == 46);
        assert (s2 == 45);
        i1.next();
        if (p1 != AbstractVersionIterator.TokenType.PART_ALPHA) {
            if (z1) return 1;
        }
        i2.insertEmptyNumber();
        return this.compare(i1, i2);
    }
}

