/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.version;

import io.smallrye.common.version.AbstractVersionIterator;
import io.smallrye.common.version.VersionSyntaxException;
import java.util.NoSuchElementException;

final class MavenVersionIterator
extends AbstractVersionIterator {
    private static final String[] MILESTONES = new String[]{"alpha", "beta", "milestone", "rc", "snapshot", "", "sp"};

    MavenVersionIterator(String string) {
        super(string);
    }

    @Override
    public boolean isEmptySeparator() {
        return false;
    }

    @Override
    public boolean isNonEmptySeparator() {
        return super.isEmptySeparator() || super.isNonEmptySeparator();
    }

    @Override
    public boolean isNumberPart() {
        return super.isNumberPart() || this.isReleaseString();
    }

    @Override
    public boolean isAlphaPart() {
        return super.isAlphaPart() && !this.isReleaseString();
    }

    @Override
    public int getSeparatorCodePoint() {
        return super.isEmptySeparator() ? 45 : super.getSeparatorCodePoint();
    }

    @Override
    public StringBuilder appendPartTo(StringBuilder target) {
        if (super.isEmptySeparator()) {
            return target.append('-');
        }
        return super.appendPartTo(target);
    }

    @Override
    public StringBuilder appendNumberPartTo(StringBuilder target) throws IllegalStateException {
        if (this.isReleaseString()) {
            return target.append('0');
        }
        return super.appendNumberPartTo(target);
    }

    @Override
    public StringBuilder appendAlphaPartTo(StringBuilder b) throws IllegalStateException {
        char cp;
        int m = this.getMilestoneMagnitude();
        if (m != -1) {
            return b.append(MILESTONES[m]);
        }
        long cookie = this.cookie;
        int start = MavenVersionIterator.cookieToStartIndex(cookie);
        int length = MavenVersionIterator.cookieToEndIndex(cookie) - start;
        for (int i = 0; i < length; i += Character.charCount(cp)) {
            cp = this.string.charAt(start + i);
            b.appendCodePoint(Character.toLowerCase((int)cp));
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        if (!super.hasNext()) {
            return false;
        }
        long mark = this.mark();
        try {
            super.next();
            AbstractVersionIterator.TokenType t = this.currentType();
            if (t == AbstractVersionIterator.TokenType.PART_ALPHA && !this.isReleaseString()) {
                boolean bl = true;
                return bl;
            }
            if (t == AbstractVersionIterator.TokenType.PART_NUMBER && !super.numberPartEquals(0)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.hasNext();
            return bl;
        }
        finally {
            this.reset(mark);
        }
    }

    @Override
    public void next() throws NoSuchElementException, VersionSyntaxException {
        super.next();
        if (this.isDotSeparator()) {
            long mark = this.mark();
            try {
                this.skipTrailer(mark);
            }
            catch (Throwable t) {
                this.reset(mark);
                throw t;
            }
        }
    }

    @Override
    protected boolean isSeparatorCodePoint(int cp) {
        return cp == 46 || cp == 45;
    }

    @Override
    protected boolean isAlphaCodePoint(int cp) {
        return !this.isSeparatorCodePoint(cp) && this.numericCodePointValue(cp) == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean nextSeparatorIsEmpty() {
        if (!this.hasNext()) {
            return false;
        }
        long mark = this.mark();
        this.next();
        try {
            boolean bl = super.isEmptySeparator();
            return bl;
        }
        finally {
            this.reset(mark);
        }
    }

    boolean isReleaseString() {
        return this.alphaPartEquals("", true) || this.alphaPartEquals("ga", true) || this.alphaPartEquals("final", true) || this.alphaPartEquals("release", true);
    }

    boolean isZeroSegment() {
        return super.isNumberPart() && super.numberPartEquals(0) || super.isAlphaPart() && this.isReleaseString();
    }

    boolean isDashSeparator() {
        return this.isSeparator() && this.getSeparatorCodePoint() == 45;
    }

    boolean isDotSeparator() {
        return this.isSeparator() && this.getSeparatorCodePoint() == 46;
    }

    void skipTrailer(long mark) {
        assert (this.isDotSeparator());
        assert (this.hasNext());
        this.next();
        if (this.isZeroSegment()) {
            assert (this.hasNext());
            this.next();
            if (!this.isDashSeparator()) {
                assert (this.isDotSeparator());
                this.skipTrailer(mark);
            }
        } else {
            this.reset(mark);
        }
    }

    int getMilestoneMagnitude() {
        if (super.isAlphaPart()) {
            boolean nextSeparatorIsEmpty = this.nextSeparatorIsEmpty();
            if (this.alphaPartEquals("alpha", true) || this.alphaPartEquals("a", true) && nextSeparatorIsEmpty) {
                return 0;
            }
            if (this.alphaPartEquals("beta", true) || this.alphaPartEquals("b", true) && nextSeparatorIsEmpty) {
                return 1;
            }
            if (this.alphaPartEquals("milestone", true) || this.alphaPartEquals("m", true) && nextSeparatorIsEmpty) {
                return 2;
            }
            if (this.alphaPartEquals("rc", true) || this.alphaPartEquals("cr", true)) {
                return 3;
            }
            if (this.alphaPartEquals("snapshot", true)) {
                return 4;
            }
            if (this.isReleaseString()) {
                return 5;
            }
            if (this.alphaPartEquals("sp", true)) {
                return 6;
            }
        } else if (this.isZeroSegment()) {
            return 5;
        }
        return -1;
    }
}

