/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.resource;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.resource.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.time.Instant;

public final class ResourceURLConnection
extends URLConnection {
    private final Resource resource;

    ResourceURLConnection(URL url, Resource resource) {
        super((URL)Assert.checkNotNullParam((String)"url", (Object)url));
        this.resource = (Resource)Assert.checkNotNullParam((String)"resource", (Object)resource);
    }

    public Resource resource() {
        return this.resource;
    }

    @Override
    public void connect() {
    }

    @Override
    public long getContentLengthLong() {
        return this.resource.size();
    }

    @Override
    public String getContentType() {
        return "application/octet-stream";
    }

    @Override
    public long getLastModified() {
        Instant instant = this.resource.modifiedTime();
        return instant == null ? 0L : instant.toEpochMilli();
    }

    @Override
    public Object getContent(Class<?> ... classes) throws IOException {
        for (Class<?> clazz : classes) {
            if (clazz == ByteBuffer.class) {
                return this.resource.asBuffer();
            }
            if (clazz == byte[].class) {
                return this.getInputStream().readAllBytes();
            }
            if (clazz != Resource.class) continue;
            return this.resource;
        }
        return null;
    }

    @Override
    public Object getContent() throws IOException {
        return this.getContent(byte[].class);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.resource.openStream();
    }
}

