/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.process;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.function.ExceptionConsumer;
import io.smallrye.common.function.ExceptionFunction;
import io.smallrye.common.process.WaitableProcessHandle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.IntPredicate;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface PipelineBuilder<O> {
    public PipelineBuilder<O> arguments(List<String> var1);

    public PipelineBuilder<O> arguments(String ... var1);

    public PipelineBuilder<O> directory(Path var1);

    public PipelineBuilder<O> environment(Map<String, String> var1);

    public PipelineBuilder<O> modifyEnvironment(Consumer<Map<String, String>> var1);

    public Output<O> output();

    public Error<O> error();

    public O run();

    public PipelineBuilder<O> exitCodeChecker(IntPredicate var1);

    public PipelineBuilder<O> whileRunning(Consumer<WaitableProcessHandle> var1);

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Error<O>
    extends PipelineBuilder<O> {
        public Error<O> discard();

        public Error<O> inherited();

        public Error<O> charset(Charset var1);

        public Error<O> nativeCharset();

        public Error<O> logOnSuccess(boolean var1);

        public Error<O> gatherOnFail(boolean var1);

        public Error<O> maxLineLength(int var1);

        public Error<O> captureHeadLines(int var1);

        public Error<O> captureTailLines(int var1);

        default public Error<O> transferTo(Writer writer) {
            Assert.checkNotNullParam((String)"writer", (Object)writer);
            return this.consumeWith((ExceptionConsumer<BufferedReader, IOException>)((ExceptionConsumer)br -> br.transferTo(writer)));
        }

        public Error<O> transferTo(Path var1);

        public Error<O> appendTo(Path var1);

        public Error<O> consumeWith(ExceptionConsumer<BufferedReader, IOException> var1);

        default public Error<O> consumeLinesWith(ExceptionConsumer<String, IOException> consumer) {
            Assert.checkNotNullParam((String)"consumer", consumer);
            return this.consumeWith((ExceptionConsumer<BufferedReader, IOException>)((ExceptionConsumer)br -> {
                String line;
                while ((line = br.readLine()) != null) {
                    consumer.accept((Object)line);
                }
            }));
        }

        public Error<O> redirect();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Output<O>
    extends PipelineBuilder<O> {
        public Output<Void> discard();

        public Output<Void> inherited();

        public Output<O> charset(Charset var1);

        public Output<O> nativeCharset();

        public Output<String> toSingleString(int var1);

        public Output<List<String>> toStringList(int var1);

        default public Output<Void> transferTo(OutputStream stream) {
            Assert.checkNotNullParam((String)"stream", (Object)stream);
            return this.consumeBytesWith((ExceptionConsumer<InputStream, IOException>)((ExceptionConsumer)is -> is.transferTo(stream)));
        }

        default public Output<Void> transferTo(Writer writer) {
            Assert.checkNotNullParam((String)"writer", (Object)writer);
            return this.consumeWith((ExceptionConsumer<BufferedReader, IOException>)((ExceptionConsumer)br -> br.transferTo(writer)));
        }

        public Output<Void> transferTo(Path var1);

        public Output<Void> appendTo(Path var1);

        default public Output<Void> consumeBytesWith(ExceptionConsumer<InputStream, IOException> consumer) {
            Assert.checkNotNullParam((String)"consumer", consumer);
            return this.processBytesWith(is -> {
                consumer.accept(is);
                return null;
            });
        }

        default public Output<Void> consumeWith(ExceptionConsumer<BufferedReader, IOException> consumer) {
            Assert.checkNotNullParam((String)"consumer", consumer);
            return this.processWith(rd -> {
                consumer.accept(rd);
                return null;
            });
        }

        default public Output<Void> consumeLinesWith(ExceptionConsumer<String, IOException> consumer) {
            Assert.checkNotNullParam((String)"consumer", consumer);
            return this.consumeWith((ExceptionConsumer<BufferedReader, IOException>)((ExceptionConsumer)br -> {
                String line;
                while ((line = br.readLine()) != null) {
                    consumer.accept((Object)line);
                }
            }));
        }

        public <O2> Output<O2> processBytesWith(ExceptionFunction<InputStream, O2, IOException> var1);

        public <O2> Output<O2> processWith(ExceptionFunction<BufferedReader, O2, IOException> var1);

        public PipelineBuilder<Void> pipeTo(Path var1);

        default public PipelineBuilder<Void> pipeTo(Path command, List<String> args) {
            return this.pipeTo(command).arguments(args);
        }

        default public PipelineBuilder<Void> pipeTo(Path command, String ... args) {
            return this.pipeTo(command).arguments(args);
        }
    }
}

