/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.process;

import io.smallrye.common.function.ExceptionConsumer;
import io.smallrye.common.function.ExceptionFunction;
import io.smallrye.common.process.AbnormalExitException;
import io.smallrye.common.process.Gatherer;
import io.smallrye.common.process.IOUtil;
import io.smallrye.common.process.LineReader;
import io.smallrye.common.process.Logging;
import io.smallrye.common.process.ProcessBuilderImpl;
import io.smallrye.common.process.ProcessExecutionException;
import io.smallrye.common.process.ProcessHandlerException;
import io.smallrye.common.process.ProcessRunner;
import io.smallrye.common.process.ProcessUtil;
import io.smallrye.common.process.Tee;
import io.smallrye.common.process.WaitableProcessHandle;
import io.smallrye.common.process.WaitableProcessHandleImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;

class PipelineRunner<O> {
    private static final VarHandle ioCountHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "ioCount", VarHandle.class, PipelineRunner.class, Integer.TYPE);
    final ProcessBuilderImpl<O> processBuilder;
    final PipelineRunner<O> prev;
    private volatile int ioCount;
    private Thread inputThread;
    private ProcessHandlerException inputProblem;
    private Thread outputMainThread;
    private List<Thread> outputExtraThreads = List.of();
    private final List<ProcessHandlerException> outputProblems = new CopyOnWriteArrayList<ProcessHandlerException>();
    private Thread errorMainThread;
    private List<Thread> errorExtraThreads = List.of();
    private final List<ProcessHandlerException> errorProblems = new CopyOnWriteArrayList<ProcessHandlerException>();
    private Thread whileRunningThread;
    private ProcessHandlerException whileRunningProblem;
    private Thread waitForThread;
    private ProcessHandlerException exitCheckerProblem;
    private AbnormalExitException abnormalExit;
    Thread asyncThread;
    Process process;
    private Gatherer errorGatherer;
    private Gatherer outputGatherer;
    private ProcessBuilder pb;

    PipelineRunner(ProcessBuilderImpl<O> processBuilder, PipelineRunner<O> prev) {
        this.processBuilder = processBuilder;
        this.prev = prev;
    }

    int createInputThread(ThreadFactory tf, ProcessRunner<?> runner) throws IOException {
        ExceptionConsumer<OutputStream, IOException> inputHandler = this.processBuilder.inputHandler;
        switch (this.processBuilder.inputStrategy) {
            case 0: {
                this.pb.redirectInput(ProcessBuilder.Redirect.DISCARD.file());
                break;
            }
            case 1: {
                this.pb.redirectInput(ProcessBuilder.Redirect.INHERIT);
                break;
            }
            case 2: {
                this.pb.redirectInput(this.processBuilder.inputFile);
                break;
            }
            case 3: {
                assert (inputHandler != null);
                this.pb.redirectInput(ProcessBuilder.Redirect.PIPE);
                this.inputThread = tf.newThread(() -> {
                    if (runner.awaitOk()) {
                        Thread.currentThread().setName("process-input-\"%s\"-%d".formatted(this.processBuilder.command.getFileName(), this.process.pid()));
                        try (OutputStream os = this.process.getOutputStream();){
                            inputHandler.accept((Object)os);
                        }
                        catch (ProcessHandlerException phe) {
                            this.inputProblem = phe;
                        }
                        catch (Throwable t) {
                            this.inputProblem = new ProcessHandlerException("Input generation failed due to exception", t);
                        }
                        finally {
                            this.ioDone();
                            runner.taskComplete();
                        }
                    }
                });
                if (this.inputThread == null) {
                    throw PipelineRunner.noThread(tf);
                }
                this.inputThread.setName("process-input-\"%s\"-???".formatted(this.processBuilder.command.getFileName()));
                this.ioRegistered();
                return 1;
            }
            case 4: {
                break;
            }
            case 5: {
                this.pb.redirectInput(ProcessBuilder.Redirect.PIPE);
            }
        }
        return 0;
    }

    int createErrorThreads(ThreadFactory tf, ProcessRunner<?> runner) throws IOException {
        int strategy = this.processBuilder.errorStrategy;
        if (strategy == 5) {
            this.pb.redirectErrorStream(true);
            return 0;
        }
        ExceptionConsumer<InputStream, IOException> eh = this.processBuilder.errorHandler;
        List<ExceptionConsumer<InputStream, IOException>> extras = this.processBuilder.extraErrorHandlers;
        ArrayList<Object> allHandlers = new ArrayList<Object>(extras.size() + 2);
        if (this.processBuilder.errorGatherOnFail || this.processBuilder.errorLogOnSuccess) {
            this.errorGatherer = new Gatherer(this.processBuilder.errorHeadLines, this.processBuilder.errorTailLines);
            allHandlers.add(is -> IOUtil.consumeToReader(is, (ExceptionConsumer<BufferedReader, IOException>)((ExceptionConsumer)br -> this.errorGatherer.run(new LineReader((Reader)br, this.processBuilder.errorLineLimit))), this.processBuilder.errorCharset));
        }
        if (eh != null) {
            allHandlers.add(eh);
        }
        allHandlers.addAll(extras);
        if (allHandlers.isEmpty() || allHandlers.size() == 1 && eh != null) {
            switch (strategy) {
                case 0: {
                    this.pb.redirectError(ProcessBuilder.Redirect.DISCARD);
                    return 0;
                }
                case 1: {
                    this.pb.redirectError(ProcessBuilder.Redirect.INHERIT);
                    return 0;
                }
                case 2: {
                    this.pb.redirectError(ProcessBuilder.Redirect.to(this.processBuilder.errorFile));
                    return 0;
                }
                case 3: {
                    this.pb.redirectError(ProcessBuilder.Redirect.appendTo(this.processBuilder.errorFile));
                    return 0;
                }
            }
        }
        this.pb.redirectError(ProcessBuilder.Redirect.PIPE);
        int handlerCnt = allHandlers.size();
        if (handlerCnt == 1) {
            ExceptionConsumer handler = (ExceptionConsumer)allHandlers.get(0);
            this.errorMainThread = tf.newThread(() -> {
                if (runner.awaitOk()) {
                    Thread.currentThread().setName("process-error-consumer-\"%s\"-%d".formatted(this.processBuilder.command.getFileName(), this.process.pid()));
                    try (InputStream is = this.process.getErrorStream();){
                        handler.accept((Object)is);
                    }
                    catch (ProcessHandlerException phe) {
                        this.errorProblems.add(phe);
                    }
                    catch (Throwable t) {
                        this.errorProblems.add(new ProcessHandlerException("User error processing failed due to exception", t));
                    }
                    finally {
                        this.ioDone();
                        runner.taskComplete();
                    }
                }
            });
            if (this.errorMainThread == null) {
                throw PipelineRunner.noThread(tf);
            }
            this.errorMainThread.setName("process-error-consumer-\"%s\"-???".formatted(this.processBuilder.command.getFileName()));
            this.ioRegistered();
            return 1;
        }
        Tee tee = new Tee(handlerCnt);
        List<Tee.TeeInputStream> outputs = tee.outputs();
        this.errorMainThread = tf.newThread(() -> {
            if (runner.awaitOk()) {
                Thread.currentThread().setName("process-error-tee-\"%s\"-%d".formatted(this.processBuilder.command.getFileName(), this.process.pid()));
                try (InputStream is = this.process.getErrorStream();){
                    tee.run(is);
                }
                catch (ProcessHandlerException phe) {
                    this.errorProblems.add(phe);
                }
                catch (Throwable t) {
                    this.errorProblems.add(new ProcessHandlerException("User error processing failed due to exception", t));
                }
                finally {
                    this.ioDone();
                    runner.taskComplete();
                }
            }
        });
        if (this.errorMainThread == null) {
            throw PipelineRunner.noThread(tf);
        }
        this.errorMainThread.setName("process-error-tee-\"%s\"-???".formatted(this.processBuilder.command.getFileName()));
        this.ioRegistered();
        ArrayList<Thread> handlerThreads = new ArrayList<Thread>(handlerCnt);
        int i = 0;
        while (i < handlerCnt) {
            Tee.TeeInputStream input;
            int idx;
            Thread thr;
            ExceptionConsumer handler = (ExceptionConsumer)allHandlers.get(i);
            if ((thr = tf.newThread(() -> this.lambda$createErrorThreads$5(runner, idx = i++, input = outputs.get(i), handler))) == null) {
                throw PipelineRunner.noThread(tf);
            }
            thr.setName("process-error-consumer-%d-\"%s\"-???".formatted(idx, this.processBuilder.command.getFileName()));
            handlerThreads.add(thr);
            this.ioRegistered();
        }
        this.errorExtraThreads = handlerThreads;
        return 1 + handlerCnt;
    }

    int createOutputThreads(ThreadFactory tf, ProcessRunner<O> runner, PipelineRunner<O> nextRunner) throws IOException {
        ExceptionFunction oh = this.processBuilder.outputHandler;
        List<ExceptionConsumer<InputStream, IOException>> extras = this.processBuilder.extraOutputHandlers;
        ArrayList<Object> allHandlers = new ArrayList<Object>(extras.size() + 2);
        if (this.processBuilder.outputGatherOnFail) {
            this.outputGatherer = new Gatherer(this.processBuilder.outputHeadLines, this.processBuilder.outputTailLines);
            allHandlers.add(is -> IOUtil.consumeToReader(is, (ExceptionConsumer<BufferedReader, IOException>)((ExceptionConsumer)br -> this.outputGatherer.run(new LineReader((Reader)br, this.processBuilder.outputLineLimit))), this.processBuilder.outputCharset));
        }
        int strategy = this.processBuilder.outputStrategy;
        if (oh != null) {
            allHandlers.add(is -> {
                runner.result = oh.apply(is);
            });
        }
        if (strategy == 6) {
            allHandlers.add(is -> {
                try (OutputStream os = nextRunner.process.getOutputStream();){
                    is.transferTo(os);
                }
                finally {
                    nextRunner.ioDone();
                }
            });
            nextRunner.ioRegistered();
            this.pb.redirectOutput(ProcessBuilder.Redirect.PIPE);
        }
        allHandlers.addAll(extras);
        if (allHandlers.isEmpty() || allHandlers.size() == 1 && oh != null) {
            switch (strategy) {
                case 0: {
                    this.pb.redirectOutput(ProcessBuilder.Redirect.DISCARD);
                    return 0;
                }
                case 1: {
                    this.pb.redirectOutput(ProcessBuilder.Redirect.INHERIT);
                    return 0;
                }
                case 2: {
                    this.pb.redirectOutput(ProcessBuilder.Redirect.to(this.processBuilder.outputFile));
                    return 0;
                }
                case 3: {
                    this.pb.redirectOutput(ProcessBuilder.Redirect.appendTo(this.processBuilder.outputFile));
                    return 0;
                }
                case 5: {
                    return 0;
                }
            }
        }
        this.pb.redirectOutput(ProcessBuilder.Redirect.PIPE);
        int handlerCnt = allHandlers.size();
        if (handlerCnt == 1) {
            ExceptionConsumer handler = (ExceptionConsumer)allHandlers.get(0);
            this.outputMainThread = tf.newThread(() -> {
                if (runner.awaitOk()) {
                    Thread.currentThread().setName("process-output-consumer-\"%s\"-%d".formatted(this.processBuilder.command.getFileName(), this.process.pid()));
                    try (InputStream is = this.process.getInputStream();){
                        handler.accept((Object)is);
                    }
                    catch (ProcessHandlerException phe) {
                        this.outputProblems.add(phe);
                    }
                    catch (Throwable t) {
                        this.outputProblems.add(new ProcessHandlerException("User output processing failed due to exception", t));
                    }
                    finally {
                        runner.ioDone();
                        runner.taskComplete();
                    }
                }
            });
            if (this.outputMainThread == null) {
                throw PipelineRunner.noThread(tf);
            }
            this.outputMainThread.setName("process-output-consumer-\"%s\"-???".formatted(this.processBuilder.command.getFileName()));
            runner.ioRegistered();
            return 1;
        }
        Tee tee = new Tee(handlerCnt);
        List<Tee.TeeInputStream> outputs = tee.outputs();
        this.outputMainThread = tf.newThread(() -> {
            if (runner.awaitOk()) {
                Thread.currentThread().setName("process-output-tee-\"%s\"-%d".formatted(this.processBuilder.command.getFileName(), this.process.pid()));
                try (InputStream is = this.process.getInputStream();){
                    tee.run(is);
                }
                catch (ProcessHandlerException phe) {
                    this.outputProblems.add(phe);
                }
                catch (Throwable t) {
                    this.outputProblems.add(new ProcessHandlerException("User output processing failed due to exception", t));
                }
                finally {
                    runner.ioDone();
                    runner.taskComplete();
                }
            }
        });
        if (this.outputMainThread == null) {
            throw PipelineRunner.noThread(tf);
        }
        this.outputMainThread.setName("process-output-tee-\"%s\"-???".formatted(this.processBuilder.command.getFileName()));
        runner.ioRegistered();
        ArrayList<Thread> handlerThreads = new ArrayList<Thread>(handlerCnt);
        int i = 0;
        while (i < handlerCnt) {
            Tee.TeeInputStream input;
            int idx;
            Thread thr;
            ExceptionConsumer handler = (ExceptionConsumer)allHandlers.get(i);
            if ((thr = tf.newThread(() -> this.lambda$createOutputThreads$12(runner, idx = i++, input = outputs.get(i), handler))) == null) {
                throw PipelineRunner.noThread(tf);
            }
            thr.setName("process-output-consumer-%d-\"%s\"-???".formatted(idx, this.processBuilder.command.getFileName()));
            handlerThreads.add(thr);
            runner.ioRegistered();
        }
        this.outputExtraThreads = handlerThreads;
        return 1 + handlerCnt;
    }

    int createWhileRunningThread(ThreadFactory tf, ProcessRunner<?> runner) throws IOException {
        Consumer<WaitableProcessHandle> whileRunning = this.processBuilder.whileRunning;
        if (whileRunning != null) {
            this.whileRunningThread = tf.newThread(() -> {
                if (runner.awaitOk()) {
                    Thread.currentThread().setName("process-while-running-\"%s\"-%d".formatted(this.processBuilder.command.getFileName(), this.process.pid()));
                    try {
                        whileRunning.accept(new WaitableProcessHandleImpl(this.process, this.processBuilder.command, this.processBuilder.arguments));
                    }
                    catch (ProcessHandlerException phe) {
                        this.whileRunningProblem = phe;
                    }
                    catch (Throwable t) {
                        this.whileRunningProblem = new ProcessHandlerException("While-running task failed due to exception", t);
                    }
                    finally {
                        this.ioDone();
                        runner.taskComplete();
                    }
                }
            });
            this.whileRunningThread.setName("process-while-running-\"%s\"-???".formatted(this.processBuilder.command.getFileName()));
            this.ioRegistered();
            if (this.whileRunningThread == null) {
                throw PipelineRunner.noThread(tf);
            }
            return 1;
        }
        return 0;
    }

    int createWaitForThread(ThreadFactory tf, ProcessRunner<?> runner) throws IOException {
        this.waitForThread = tf.newThread(() -> {
            block20: {
                if (runner.awaitOk()) {
                    Thread.currentThread().setName("process-waiter-\"%s\"-%d".formatted(this.processBuilder.command.getFileName(), this.process.pid()));
                    try {
                        boolean result;
                        int exitCode;
                        boolean ste = false;
                        boolean hte = false;
                        this.awaitIoDone();
                        if (this.process.isAlive() && this.processBuilder.softExitTimeout != null && ProcessUtil.stillRunningAfter(this.process, this.processBuilder.softExitTimeout.get(ChronoUnit.NANOS))) {
                            ste = true;
                            if (this.process.supportsNormalTermination()) {
                                this.process.destroy();
                            }
                        }
                        if (this.process.isAlive() && this.processBuilder.hardExitTimeout != null && ProcessUtil.stillRunningAfter(this.process, this.processBuilder.hardExitTimeout.get(ChronoUnit.NANOS))) {
                            hte = true;
                            ProcessUtil.destroyAllForcibly(this.process.toHandle());
                        }
                        while (true) {
                            try {
                                exitCode = this.process.waitFor();
                            }
                            catch (InterruptedException interruptedException) {
                                continue;
                            }
                            break;
                        }
                        List<String> errorLines = this.errorGatherer.toList();
                        try {
                            result = this.processBuilder.exitCodeChecker.test(exitCode);
                        }
                        catch (ProcessHandlerException phe) {
                            this.exitCheckerProblem = phe;
                            runner.taskComplete();
                            return;
                        }
                        catch (Throwable t) {
                            this.exitCheckerProblem = new ProcessHandlerException("Exit code checker task failed due to exception", t);
                            runner.taskComplete();
                            return;
                        }
                        if (!result) {
                            AbnormalExitException aee = new AbnormalExitException("Process exited abnormally");
                            aee.setExitCode(exitCode);
                            aee.setSoftTimeoutElapsed(ste);
                            aee.setHardTimeoutElapsed(hte);
                            if (this.processBuilder.errorGatherOnFail) {
                                aee.setErrorOutput(errorLines);
                            }
                            if (this.processBuilder.outputGatherOnFail) {
                                List<String> outputLines = this.outputGatherer.toList();
                                aee.setOutput(outputLines);
                            }
                            aee.setCommand(this.processBuilder.command);
                            aee.setArguments(this.processBuilder.arguments);
                            aee.setPid(this.process.pid());
                            this.abnormalExit = aee;
                        } else if (this.processBuilder.errorLogOnSuccess && !errorLines.isEmpty()) {
                            StringBuilder sb = new StringBuilder(512);
                            errorLines.forEach(line -> sb.append("\n\t").append((String)line));
                            Logging.log.logErrors(this.processBuilder.command, this.process.pid(), sb);
                        }
                        break block20;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        runner.taskComplete();
                    }
                }
            }
        });
        if (this.waitForThread == null) {
            throw PipelineRunner.noThread(tf);
        }
        this.waitForThread.setName("process-waiter-\"%s\"-???".formatted(this.processBuilder.command.getFileName()));
        return 1;
    }

    void startThreads() {
        PipelineRunner.startThread(this.inputThread);
        PipelineRunner.startThread(this.outputMainThread);
        this.outputExtraThreads.forEach(Thread::start);
        PipelineRunner.startThread(this.errorMainThread);
        this.errorExtraThreads.forEach(Thread::start);
        PipelineRunner.startThread(this.whileRunningThread);
        PipelineRunner.startThread(this.waitForThread);
        PipelineRunner.startThread(this.asyncThread);
        if (this.prev != null) {
            this.prev.startThreads();
        }
    }

    static void startThread(Thread thread) {
        if (thread != null) {
            thread.start();
        }
    }

    private void awaitIoDone() {
        int ioCount = this.ioCount;
        while (ioCount != 0) {
            LockSupport.park(this);
            ioCount = this.ioCount;
        }
    }

    void ioRegistered() {
        ++this.ioCount;
    }

    void ioDone() {
        int oldVal = ioCountHandle.getAndAdd(this, -1);
        if (oldVal == 1) {
            LockSupport.unpark(this.waitForThread);
        }
    }

    static IOException noThread(ThreadFactory tf) {
        return new IOException("Thread factory %s did not create a thread".formatted(tf));
    }

    void unpark() {
        LockSupport.unpark(this.inputThread);
        LockSupport.unpark(this.outputMainThread);
        this.outputExtraThreads.forEach(LockSupport::unpark);
        LockSupport.unpark(this.errorMainThread);
        this.errorExtraThreads.forEach(LockSupport::unpark);
        LockSupport.unpark(this.whileRunningThread);
        LockSupport.unpark(this.waitForThread);
        LockSupport.unpark(this.asyncThread);
        if (this.prev != null) {
            this.prev.unpark();
        }
    }

    void collectProblems(List<ProcessExecutionException> problems) {
        ProcessExecutionException pe;
        if (this.prev != null) {
            this.prev.collectProblems(problems);
        }
        if (!((pe = this.abnormalExit) != null || this.inputProblem == null && this.outputProblems.isEmpty() && this.errorProblems.isEmpty() && this.exitCheckerProblem == null && this.whileRunningProblem == null)) {
            pe = this.newProcessException("Process handle failure");
        }
        if (pe != null) {
            ArrayList<ProcessHandlerException> causes = new ArrayList<ProcessHandlerException>(6);
            if (this.inputProblem != null) {
                causes.add(this.inputProblem);
            }
            causes.addAll(this.outputProblems);
            causes.addAll(this.errorProblems);
            if (this.whileRunningProblem != null) {
                causes.add(this.whileRunningProblem);
            }
            if (this.exitCheckerProblem != null) {
                causes.add(this.exitCheckerProblem);
            }
            switch (causes.size()) {
                case 1: {
                    pe.initCause((Throwable)causes.get(0));
                    break;
                }
                default: {
                    causes.forEach(pe::addSuppressed);
                }
            }
            problems.add(pe);
        }
    }

    ProcessExecutionException newProcessException(String message) {
        ProcessExecutionException pe = new ProcessExecutionException(message);
        if (this.process != null) {
            pe.setPid(this.process.pid());
        }
        pe.setCommand(this.processBuilder.command);
        pe.setArguments(this.processBuilder.arguments);
        return pe;
    }

    int createThreads(ThreadFactory tf, ProcessRunner<O> runner, PipelineRunner<O> nextRunner) throws IOException {
        this.pb = this.processBuilder.pb;
        this.pb.command(this.processBuilder.argumentRule.formatArguments(this.processBuilder.command, this.processBuilder.arguments));
        this.pb.directory(this.processBuilder.directory);
        int cnt = this.createInputThread(tf, runner) + this.createErrorThreads(tf, runner) + this.createOutputThreads(tf, runner, nextRunner) + this.createWhileRunningThread(tf, runner) + this.createWaitForThread(tf, runner);
        return this.prev == null ? cnt : cnt + this.prev.createThreads(tf, runner, this);
    }

    void startProcesses(int pipelineEnd, List<Process> processes, List<ProcessBuilder> builders) throws IOException {
        int depth = this.processBuilder.depth;
        int index = depth - 1;
        builders.set(index, this.pb);
        if (this.processBuilder.outputStrategy != 6) {
            if (this.prev == null) {
                processes.addAll(ProcessBuilder.startPipeline(builders.subList(0, pipelineEnd)));
            } else {
                this.prev.startProcesses(pipelineEnd, processes, builders);
            }
        } else {
            if (this.prev != null) {
                this.prev.startProcesses(depth, processes, builders);
            }
            if (depth < pipelineEnd) {
                processes.addAll(ProcessBuilder.startPipeline(builders.subList(depth, pipelineEnd)));
            }
        }
        this.process = processes.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$createOutputThreads$12(ProcessRunner runner, int idx, Tee.TeeInputStream input, ExceptionConsumer handler) {
        if (runner.awaitOk()) {
            Thread.currentThread().setName("process-output-consumer-%d-\"%s\"-%d".formatted(idx, this.processBuilder.command.getFileName(), this.process.pid()));
            try (Tee.TeeInputStream teeInputStream = input;){
                handler.accept((Object)input);
            }
            catch (ProcessHandlerException phe) {
                this.outputProblems.add(phe);
            }
            catch (Throwable t) {
                this.outputProblems.add(new ProcessHandlerException("User output processing failed due to exception", t));
            }
            finally {
                runner.ioDone();
                runner.taskComplete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$createErrorThreads$5(ProcessRunner runner, int idx, Tee.TeeInputStream input, ExceptionConsumer handler) {
        if (runner.awaitOk()) {
            Thread.currentThread().setName("process-error-consumer-%d-\"%s\"-%d".formatted(idx, this.processBuilder.command.getFileName(), this.process.pid()));
            try (Tee.TeeInputStream teeInputStream = input;){
                handler.accept((Object)input);
            }
            catch (ProcessHandlerException phe) {
                this.errorProblems.add(phe);
            }
            catch (Throwable t) {
                this.errorProblems.add(new ProcessHandlerException("User error processing failed due to exception", t));
            }
            finally {
                this.ioDone();
                runner.taskComplete();
            }
        }
    }
}

