/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.cpu;

import io.smallrye.common.cpu.JDK22Specific;
import java.nio.ByteOrder;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum CPU {
    unknown32(4, ByteOrder.LITTLE_ENDIAN, Set.of(), true),
    unknown32be(4, ByteOrder.BIG_ENDIAN, Set.of(), true),
    unknown64(8, ByteOrder.LITTLE_ENDIAN, Set.of("unknown"), true),
    unknown64be(8, ByteOrder.BIG_ENDIAN, Set.of(), true),
    x64(8, ByteOrder.LITTLE_ENDIAN, Set.of("x86_64", "amd64"), false),
    x86(4, ByteOrder.LITTLE_ENDIAN, Set.of("i386", "i486", "i586", "i686"), false),
    aarch64(8, ByteOrder.LITTLE_ENDIAN, Set.of("arm64"), false),
    arm(4, ByteOrder.LITTLE_ENDIAN, Set.of("armv7", "armv7hl", "aarch32"), false),
    riscv(8, ByteOrder.LITTLE_ENDIAN, Set.of("riscv64"), false),
    ppc32(4, ByteOrder.BIG_ENDIAN, Set.of("ppc32be"), false),
    ppc32le(4, ByteOrder.LITTLE_ENDIAN, Set.of(), false),
    ppc(8, ByteOrder.BIG_ENDIAN, Set.of("ppc64", "ppcbe", "ppc64be"), false),
    ppcle(8, ByteOrder.LITTLE_ENDIAN, Set.of("ppc64le"), false),
    wasm32(4, ByteOrder.LITTLE_ENDIAN, Set.of("wasm"), false),
    mips(4, ByteOrder.BIG_ENDIAN, Set.of("mips32, mipsbe, mips32be"), false),
    mipsel(4, ByteOrder.LITTLE_ENDIAN, Set.of("mips32el"), false),
    mips64(4, ByteOrder.BIG_ENDIAN, Set.of("mips64be"), false),
    mips64el(4, ByteOrder.LITTLE_ENDIAN, Set.of(), false);

    public static final List<CPU> values;
    private static final CPU hostCpu;
    private static final List<Map.Entry<String, CPU>> index;
    private final int pointerSizeBytes;
    private final ByteOrder nativeByteOrder;
    private final Set<String> aliases;
    private final boolean unknown;

    private CPU(int pointerSizeBytes, ByteOrder nativeByteOrder, Set<String> aliases, boolean unknown) {
        this.pointerSizeBytes = pointerSizeBytes;
        this.nativeByteOrder = nativeByteOrder;
        this.aliases = aliases;
        this.unknown = unknown;
    }

    public int pointerSizeBytes() {
        return this.pointerSizeBytes;
    }

    public int pointerSizeBits() {
        return this.pointerSizeBytes << 3;
    }

    public ByteOrder nativeByteOrder() {
        return this.nativeByteOrder;
    }

    public Set<String> aliases() {
        return this.aliases;
    }

    public boolean isUnknown() {
        return this.unknown;
    }

    public static CPU forName(String name) throws NoSuchElementException {
        CPU cpu = CPU.forNameOrNull(name);
        if (cpu == null) {
            throw new NoSuchElementException();
        }
        return cpu;
    }

    public static CPU forNameOrNull(String name) throws NoSuchElementException {
        Comparator cmp = String::compareToIgnoreCase;
        int low = 0;
        int high = index.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Map.Entry<String, CPU> entry = index.get(mid);
            int res = cmp.compare(entry.getKey(), name);
            if (res < 0) {
                low = mid + 1;
                continue;
            }
            if (res > 0) {
                high = mid - 1;
                continue;
            }
            return entry.getValue();
        }
        return null;
    }

    public static Optional<CPU> forNameOpt(String name) throws NoSuchElementException {
        return Optional.ofNullable(CPU.forNameOrNull(name));
    }

    public static CPU host() {
        return hostCpu;
    }

    private static CPU check(CPU cpu) {
        ByteOrder no = ByteOrder.nativeOrder();
        int bytes = JDK22Specific.ADDRESS_SIZE;
        if (cpu.pointerSizeBytes() == bytes && cpu.nativeByteOrder() == no) {
            return cpu;
        }
        return no == ByteOrder.BIG_ENDIAN ? (bytes == 4 ? unknown32be : unknown64be) : (bytes == 4 ? unknown32 : unknown64);
    }

    static {
        values = List.of(CPU.values());
        index = values.stream().flatMap(cpu -> Stream.concat(Stream.of(cpu.name()), cpu.aliases().stream()).map(v -> Map.entry(v, cpu))).sorted(Map.Entry.comparingByKey(String::compareToIgnoreCase)).collect(Collectors.toUnmodifiableList());
        hostCpu = CPU.forNameOpt(System.getProperty("os.arch", "???")).map(CPU::check).orElseThrow();
    }
}

