/*
 * Decompiled with CFR 0.152.
 */
package io.skygear.plugins.chat.ui.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Environment;
import io.skygear.plugins.chat.ui.utils.ImageData;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\u001a&\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0018\u0010\u001a\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u001c"}, d2={"IMAGE_SIZE", "", "THUMBNAIL_SIZE", "mCurrentPhotoPath", "", "getMCurrentPhotoPath", "()Ljava/lang/String;", "setMCurrentPhotoPath", "(Ljava/lang/String;)V", "bitmapToByteArray", "", "bmp", "Landroid/graphics/Bitmap;", "createImageFile", "Ljava/io/File;", "context", "Landroid/content/Context;", "getBitmap", "uri", "Landroid/net/Uri;", "ratio", "orientation", "", "getPowerOfTwoForSampleRatio", "getResizedBitmap", "Lio/skygear/plugins/chat/ui/utils/ImageData;", "rotateBitmap", "bitmap", "chat_ui_release"})
public final class ImageUtilsKt {
    private static final double THUMBNAIL_SIZE = 80.0;
    private static final double IMAGE_SIZE = 1600.0;
    @NotNull
    private static String mCurrentPhotoPath;

    @NotNull
    public static final String getMCurrentPhotoPath() {
        return mCurrentPhotoPath;
    }

    public static final void setMCurrentPhotoPath(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
        mCurrentPhotoPath = string2;
    }

    @Nullable
    public static final ImageData getResizedBitmap(@NotNull Context context, @NotNull Uri uri) {
        int len;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        InputStream input = context.getContentResolver().openInputStream(uri);
        BitmapFactory.Options onlyBoundsOptions = new BitmapFactory.Options();
        onlyBoundsOptions.inJustDecodeBounds = true;
        onlyBoundsOptions.inPreferredConfig = Bitmap.Config.ARGB_8888;
        BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)onlyBoundsOptions);
        input.close();
        if (onlyBoundsOptions.outWidth == -1 || onlyBoundsOptions.outHeight == -1) {
            return null;
        }
        input = context.getContentResolver().openInputStream(uri);
        File file = File.createTempFile("image_tmp", ".jpg", context.getCacheDir());
        FileOutputStream fos = new FileOutputStream(file);
        byte[] buffer = new byte[1024];
        while ((len = input.read(buffer, 0, 1024)) != -1) {
            fos.write(buffer, 0, len);
        }
        input.close();
        fos.close();
        ExifInterface ef = new ExifInterface(file.toString());
        int orientation = ef.getAttributeInt("Orientation", 99);
        int originalSize = onlyBoundsOptions.outHeight > onlyBoundsOptions.outWidth ? onlyBoundsOptions.outHeight : onlyBoundsOptions.outWidth;
        double imgRatio = (double)originalSize > IMAGE_SIZE ? (double)originalSize / IMAGE_SIZE : 1.0;
        Bitmap bitmap = ImageUtilsKt.getBitmap(context, uri, imgRatio, orientation);
        double thumbRatio = (double)originalSize > THUMBNAIL_SIZE ? (double)originalSize / THUMBNAIL_SIZE : 1.0;
        Bitmap thumbBitmap = ImageUtilsKt.getBitmap(context, uri, thumbRatio, orientation);
        return new ImageData(thumbBitmap, bitmap);
    }

    @NotNull
    public static final Bitmap getBitmap(@NotNull Context context, @NotNull Uri uri, double ratio, int orientation) {
        Bitmap bitmap;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        BitmapFactory.Options bitmapOptions = new BitmapFactory.Options();
        bitmapOptions.inSampleSize = ImageUtilsKt.getPowerOfTwoForSampleRatio(ratio);
        bitmapOptions.inPreferredConfig = Bitmap.Config.ARGB_8888;
        InputStream input = context.getContentResolver().openInputStream(uri);
        Bitmap bitmap2 = bitmap = BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)bitmapOptions);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"bitmap");
        bitmap = ImageUtilsKt.rotateBitmap(bitmap2, orientation);
        input.close();
        Bitmap bitmap3 = bitmap;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"bitmap");
        return bitmap3;
    }

    @Nullable
    public static final byte[] bitmapToByteArray(@NotNull Bitmap bmp) {
        Intrinsics.checkParameterIsNotNull((Object)bmp, (String)"bmp");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bmp.compress(Bitmap.CompressFormat.JPEG, 70, (OutputStream)stream);
        return stream.toByteArray();
    }

    @Nullable
    public static final Bitmap rotateBitmap(@NotNull Bitmap bitmap, int orientation) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        Matrix matrix = new Matrix();
        switch (orientation) {
            case 1: {
                return bitmap;
            }
            case 2: {
                matrix.setScale(-1.0f, 1.0f);
                break;
            }
            case 3: {
                matrix.setRotate(180.0f);
                break;
            }
            case 4: {
                matrix.setRotate(180.0f);
                matrix.postScale(-1.0f, 1.0f);
                break;
            }
            case 5: {
                matrix.setRotate(90.0f);
                matrix.postScale(-1.0f, 1.0f);
                break;
            }
            case 6: {
                matrix.setRotate(90.0f);
                break;
            }
            case 7: {
                matrix.setRotate(-90.0f);
                matrix.postScale(-1.0f, 1.0f);
                break;
            }
            case 8: {
                matrix.setRotate(-90.0f);
                break;
            }
            default: {
                return bitmap;
            }
        }
        try {
            Bitmap bmRotated = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
            bitmap.recycle();
            return bmRotated;
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            return null;
        }
    }

    @NotNull
    public static final File createImageFile(@NotNull Context context) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String imageFileName = "JPEG_" + timeStamp + "_";
        File storageDir = context.getExternalFilesDir(Environment.DIRECTORY_PICTURES);
        File image = File.createTempFile(imageFileName, ".jpg", storageDir);
        String string2 = image.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"image.getAbsolutePath()");
        mCurrentPhotoPath = string2;
        File file = image;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"image");
        return file;
    }

    private static final int getPowerOfTwoForSampleRatio(double ratio) {
        int k = Integer.highestOneBit((int)Math.floor(ratio));
        return k == 0 ? 1 : k;
    }

    static {
        THUMBNAIL_SIZE = 80.0;
        IMAGE_SIZE = 1600.0;
        mCurrentPhotoPath = "";
    }
}

