/*
 * Decompiled with CFR 0.152.
 */
package io.skygear.plugins.chat.ui.utils;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.TextUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0002\u0015\u0016B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/skygear/plugins/chat/ui/utils/AvatarBuilder;", "", "()V", "avatarWidth", "", "avatarHeight", "avatarTextSize", "cacheSize", "(IIILjava/lang/Integer;)V", "getAvatarHeight", "()I", "getAvatarTextSize", "getAvatarWidth", "cache", "Lio/skygear/plugins/chat/ui/utils/AvatarBuilder$AvatarCache;", "avatarForUri", "Landroid/graphics/Bitmap;", "uri", "", "isValidAvatarBuilderUri", "", "AvatarCache", "Companion", "chat_ui_release"})
public final class AvatarBuilder {
    private AvatarCache cache;
    private final int avatarWidth;
    private final int avatarHeight;
    private final int avatarTextSize;
    private static final String Scheme;
    private static final String NameQueryKey = "name";
    private static final String BackgroundColorQueryKey = "backgroundColor";
    private static final String InitialTextColorQueryKey = "initialTextColor";
    private static final int DefaultAvatarWidth = 100;
    private static final int DefaultAvatarHeight = 100;
    private static final int DefaultAvatarTextSize = 50;
    public static final Companion Companion;

    public final boolean isValidAvatarBuilderUri(@NotNull String uri) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        return Intrinsics.areEqual((Object)new URI(uri).getScheme(), (Object)AvatarBuilder.Companion.getScheme());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Bitmap avatarForUri(@NotNull String uri) {
        Integer n;
        Paint textPaint;
        Integer n2;
        String initials;
        void $receiver$iv$iv;
        void $receiver$iv;
        void initial$iv;
        Collection<String> collection;
        List it;
        Object object;
        HashMap $receiver$iv$iv2;
        Iterable $receiver$iv2;
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        URI parsed = new URI(uri);
        Iterable iterable = StringsKt.split$default((CharSequence)parsed.getQuery(), (char[])new char[]{'&'}, (boolean)false, (int)0, (int)6, null);
        void var5_4 = $receiver$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        Iterator iterator = $receiver$iv$iv2.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv = iterator.next();
            String string2 = (String)item$iv$iv;
            object = destination$iv$iv;
            char[] cArray = new char[]{'='};
            boolean bl = false;
            int n3 = 2;
            collection = StringsKt.split$default((CharSequence)((CharSequence)((Object)it)), (char[])cArray, (boolean)bl, (int)n3, (int)2, null);
            object.add(collection);
        }
        $receiver$iv2 = (List)destination$iv$iv;
        $receiver$iv$iv2 = new HashMap();
        Object accumulator$iv = initial$iv;
        for (Object element$iv : $receiver$iv2) {
            Iterator item;
            it = (List)element$iv;
            void acc = accumulator$iv;
            String itemKey = (String)item.get(0);
            String itemValue = (String)item.get(1);
            if (acc.containsKey(itemKey)) {
                Object v = acc.get(itemKey);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                ((List)v).add(itemValue);
            } else {
                Map $i$a$1$map = (Map)acc;
                List $i$f$mapTo = CollectionsKt.mutableListOf((Object[])new String[]{itemValue});
                $i$a$1$map.put(itemKey, $i$f$mapTo);
            }
            accumulator$iv = acc;
        }
        void queries = accumulator$iv;
        List list = (List)queries.get(AvatarBuilder.Companion.getNameQueryKey());
        String string3 = list != null ? (String)CollectionsKt.first((List)list) : null;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        String name = string3;
        accumulator$iv = new char[]{' '};
        boolean bl = false;
        int element$iv = 2;
        accumulator$iv = StringsKt.split$default((CharSequence)name, (char[])accumulator$iv, (boolean)bl, (int)element$iv, (int)2, null);
        object = "";
        void var7_8 = $receiver$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            String string4;
            void str;
            String itemKey = (String)item$iv$iv;
            collection = destination$iv$iv2;
            CharSequence itemValue = (CharSequence)str;
            if (itemValue.length() > 0) {
                itemValue = str;
                int $i$a$1$map = 0;
                int $i$f$mapTo = 1;
                CharSequence charSequence = itemValue;
                if (charSequence == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = ((String)charSequence).substring($i$a$1$map, $i$f$mapTo);
                string4 = string5;
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            } else {
                string4 = "";
            }
            String string6 = string4;
            collection.add(string6);
        }
        collection = (List)destination$iv$iv2;
        String string7 = initials = TextUtils.join((CharSequence)object, (Iterable)collection);
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"initials");
        Bitmap cachedBitmap = this.cache.get(string7);
        if (cachedBitmap != null) {
            return cachedBitmap;
        }
        Bitmap bm = Bitmap.createBitmap((int)this.avatarWidth, (int)this.avatarHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bm);
        Object object2 = (List)queries.get(AvatarBuilder.Companion.getBackgroundColorQueryKey());
        if (object2 != null && (object2 = (String)CollectionsKt.first((List)object2)) != null) {
            Object item$iv$iv;
            item$iv$iv = object2;
            n2 = Integer.parseInt(item$iv$iv);
        } else {
            n2 = null;
        }
        if (n2 == null) {
            Intrinsics.throwNpe();
        }
        int backgroundColor = n2;
        Paint backgroundPaint = new Paint();
        backgroundPaint.setColor(backgroundColor);
        backgroundPaint.setStyle(Paint.Style.FILL);
        canvas.drawPaint(backgroundPaint);
        Object object3 = textPaint = new Paint();
        Object object4 = (List)queries.get(AvatarBuilder.Companion.getInitialTextColorQueryKey());
        if (object4 != null && (object4 = (String)CollectionsKt.first((List)object4)) != null) {
            Object itemValue = object4;
            object = object3;
            int n4 = Integer.parseInt((String)itemValue);
            object3 = object;
            n = n4;
        } else {
            n = null;
        }
        if (n == null) {
            Intrinsics.throwNpe();
        }
        object3.setColor(n.intValue());
        textPaint.setStyle(Paint.Style.FILL);
        textPaint.setTextSize((float)this.avatarTextSize * 1.0f);
        textPaint.setFlags(1);
        Rect textBound = new Rect();
        textPaint.getTextBounds(initials, 0, initials.length(), textBound);
        float xPos = (float)canvas.getWidth() * 0.5f - textBound.exactCenterX();
        float yPos = (float)canvas.getHeight() * 0.5f - textBound.exactCenterY();
        canvas.drawText(initials, xPos, yPos, textPaint);
        Bitmap bitmap = bm;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"bm");
        this.cache.add(initials, bitmap);
        return bm;
    }

    public final int getAvatarWidth() {
        return this.avatarWidth;
    }

    public final int getAvatarHeight() {
        return this.avatarHeight;
    }

    public final int getAvatarTextSize() {
        return this.avatarTextSize;
    }

    public AvatarBuilder(int avatarWidth, int avatarHeight, int avatarTextSize, @Nullable Integer cacheSize) {
        this.avatarWidth = avatarWidth;
        this.avatarHeight = avatarHeight;
        this.avatarTextSize = avatarTextSize;
        this.cache = new AvatarCache(cacheSize);
    }

    public /* synthetic */ AvatarBuilder(int n, int n2, int n3, Integer n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 8) != 0) {
            n4 = null;
        }
        this(n, n2, n3, n4);
    }

    public AvatarBuilder() {
        this(Companion.getDefaultAvatarWidth(), Companion.getDefaultAvatarHeight(), Companion.getDefaultAvatarTextSize(), null, 8, null);
    }

    static {
        Companion = new Companion(null);
        Scheme = AvatarBuilder.class.getCanonicalName();
        NameQueryKey = NameQueryKey;
        BackgroundColorQueryKey = BackgroundColorQueryKey;
        InitialTextColorQueryKey = InitialTextColorQueryKey;
        DefaultAvatarWidth = 100;
        DefaultAvatarHeight = 100;
        DefaultAvatarTextSize = 50;
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0002\u0011\u0012B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/skygear/plugins/chat/ui/utils/AvatarBuilder$AvatarCache;", "", "cacheSize", "", "(Ljava/lang/Integer;)V", "getCacheSize", "()I", "items", "Ljava/util/PriorityQueue;", "Lio/skygear/plugins/chat/ui/utils/AvatarBuilder$AvatarCache$AvatarCacheItem;", "add", "", "name", "", "content", "Landroid/graphics/Bitmap;", "get", "AvatarCacheItem", "Companion", "chat_ui_release"})
    public static final class AvatarCache {
        private final int cacheSize;
        private PriorityQueue<AvatarCacheItem> items;
        private static final int DefaultCacheSize = 20;
        public static final Companion Companion = new Companion(null);

        public final int getCacheSize() {
            return this.cacheSize;
        }

        @Nullable
        public final Bitmap get(@NotNull String name) {
            int idx;
            block3: {
                int n;
                Intrinsics.checkParameterIsNotNull((Object)name, (String)AvatarBuilder.NameQueryKey);
                Iterable $receiver$iv = this.items;
                int index$iv = 0;
                for (Object item$iv : $receiver$iv) {
                    AvatarCacheItem it = (AvatarCacheItem)item$iv;
                    if (Intrinsics.areEqual((Object)it.getName(), (Object)name)) {
                        n = index$iv;
                        break block3;
                    }
                    ++index$iv;
                }
                n = idx = -1;
            }
            if (idx == -1) {
                return null;
            }
            AvatarCacheItem found = (AvatarCacheItem)CollectionsKt.elementAt((Iterable)this.items, (int)idx);
            this.items.remove(found);
            this.items.add(new AvatarCacheItem(found.getName(), found.getContent(), new Date()));
            return found.getContent();
        }

        public final void add(@NotNull String name, @NotNull Bitmap content) {
            AvatarCacheItem found;
            Object v0;
            Object object;
            block3: {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)AvatarBuilder.NameQueryKey);
                Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
                object = this.items;
                Iterable iterable = object;
                for (Object t : iterable) {
                    AvatarCacheItem it = (AvatarCacheItem)t;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            AvatarCacheItem avatarCacheItem = found = (AvatarCacheItem)v0;
            if (avatarCacheItem != null) {
                Object it = object = avatarCacheItem;
                this.items.remove(it);
            }
            this.items.add(new AvatarCacheItem(name, content, new Date()));
            while (this.items.size() > this.cacheSize) {
                this.items.remove(CollectionsKt.last((Iterable)this.items));
            }
        }

        public AvatarCache(@Nullable Integer cacheSize) {
            this.cacheSize = cacheSize != null && cacheSize > 0 ? cacheSize.intValue() : Companion.getDefaultCacheSize();
            this.items = new PriorityQueue(this.cacheSize);
        }

        static {
            DefaultCacheSize = 20;
        }

        @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0082\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lio/skygear/plugins/chat/ui/utils/AvatarBuilder$AvatarCache$AvatarCacheItem;", "", "name", "", "content", "Landroid/graphics/Bitmap;", "lastHit", "Ljava/util/Date;", "(Ljava/lang/String;Landroid/graphics/Bitmap;Ljava/util/Date;)V", "getContent", "()Landroid/graphics/Bitmap;", "getLastHit", "()Ljava/util/Date;", "getName", "()Ljava/lang/String;", "compareTo", "", "other", "component1", "component2", "component3", "copy", "equals", "", "", "hashCode", "toString", "chat_ui_release"})
        private static final class AvatarCacheItem
        implements Comparable<AvatarCacheItem> {
            @NotNull
            private final String name;
            @NotNull
            private final Bitmap content;
            @NotNull
            private final Date lastHit;

            @Override
            public int compareTo(@NotNull AvatarCacheItem other) {
                Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
                return -1 * this.lastHit.compareTo(other.lastHit);
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            @NotNull
            public final Bitmap getContent() {
                return this.content;
            }

            @NotNull
            public final Date getLastHit() {
                return this.lastHit;
            }

            public AvatarCacheItem(@NotNull String name, @NotNull Bitmap content, @NotNull Date lastHit) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)AvatarBuilder.NameQueryKey);
                Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
                Intrinsics.checkParameterIsNotNull((Object)lastHit, (String)"lastHit");
                this.name = name;
                this.content = content;
                this.lastHit = lastHit;
            }

            @NotNull
            public final String component1() {
                return this.name;
            }

            @NotNull
            public final Bitmap component2() {
                return this.content;
            }

            @NotNull
            public final Date component3() {
                return this.lastHit;
            }

            @NotNull
            public final AvatarCacheItem copy(@NotNull String name, @NotNull Bitmap content, @NotNull Date lastHit) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)AvatarBuilder.NameQueryKey);
                Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
                Intrinsics.checkParameterIsNotNull((Object)lastHit, (String)"lastHit");
                return new AvatarCacheItem(name, content, lastHit);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ AvatarCacheItem copy$default(AvatarCacheItem avatarCacheItem, String string2, Bitmap bitmap, Date date, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = avatarCacheItem.name;
                }
                if ((n & 2) != 0) {
                    bitmap = avatarCacheItem.content;
                }
                if ((n & 4) != 0) {
                    date = avatarCacheItem.lastHit;
                }
                return avatarCacheItem.copy(string2, bitmap, date);
            }

            public String toString() {
                return "AvatarCacheItem(name=" + this.name + ", content=" + this.content + ", lastHit=" + this.lastHit + ")";
            }

            public int hashCode() {
                String string2 = this.name;
                Bitmap bitmap = this.content;
                Date date = this.lastHit;
                return ((string2 != null ? string2.hashCode() : 0) * 31 + (bitmap != null ? bitmap.hashCode() : 0)) * 31 + (date != null ? ((Object)date).hashCode() : 0);
            }

            public boolean equals(Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof AvatarCacheItem)) break block3;
                        AvatarCacheItem avatarCacheItem = (AvatarCacheItem)object;
                        if (!Intrinsics.areEqual((Object)this.name, (Object)avatarCacheItem.name) || !Intrinsics.areEqual((Object)this.content, (Object)avatarCacheItem.content) || !Intrinsics.areEqual((Object)this.lastHit, (Object)avatarCacheItem.lastHit)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/skygear/plugins/chat/ui/utils/AvatarBuilder$AvatarCache$Companion;", "", "()V", "DefaultCacheSize", "", "getDefaultCacheSize", "()I", "chat_ui_release"})
        public static final class Companion {
            public final int getDefaultCacheSize() {
                return DefaultCacheSize;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0012\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0014\u0010\u000f\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u001c\u0010\u0013\u001a\n \u0014*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lio/skygear/plugins/chat/ui/utils/AvatarBuilder$Companion;", "", "()V", "BackgroundColorQueryKey", "", "getBackgroundColorQueryKey", "()Ljava/lang/String;", "DefaultAvatarHeight", "", "getDefaultAvatarHeight", "()I", "DefaultAvatarTextSize", "getDefaultAvatarTextSize", "DefaultAvatarWidth", "getDefaultAvatarWidth", "InitialTextColorQueryKey", "getInitialTextColorQueryKey", "NameQueryKey", "getNameQueryKey", "Scheme", "kotlin.jvm.PlatformType", "getScheme", "avatarUriForName", "name", "backgroundColor", "initialTextColor", "chat_ui_release"})
    public static final class Companion {
        private final String getScheme() {
            return Scheme;
        }

        private final String getNameQueryKey() {
            return NameQueryKey;
        }

        private final String getBackgroundColorQueryKey() {
            return BackgroundColorQueryKey;
        }

        private final String getInitialTextColorQueryKey() {
            return InitialTextColorQueryKey;
        }

        public final int getDefaultAvatarWidth() {
            return DefaultAvatarWidth;
        }

        public final int getDefaultAvatarHeight() {
            return DefaultAvatarHeight;
        }

        public final int getDefaultAvatarTextSize() {
            return DefaultAvatarTextSize;
        }

        @NotNull
        public final String avatarUriForName(@NotNull String name, int backgroundColor, int initialTextColor) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)AvatarBuilder.NameQueryKey);
            return "" + Companion.getScheme() + "://user?name=" + name + "&backgroundColor=" + backgroundColor + "&initialTextColor=" + initialTextColor;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

