/*
 * Decompiled with CFR 0.152.
 */
package io.skygear.chatkit.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.net.Uri;
import android.support.annotation.DimenRes;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;

public class RoundedImageView
extends AppCompatImageView {
    private int mResource = 0;
    private Drawable mDrawable;
    private float[] mRadii = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};

    public RoundedImageView(Context context) {
        super(context);
    }

    public RoundedImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public RoundedImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.invalidate();
    }

    public void setImageDrawable(Drawable drawable2) {
        this.mResource = 0;
        this.mDrawable = RoundedCornerDrawable.fromDrawable(drawable2, this.getResources());
        super.setImageDrawable(this.mDrawable);
        this.updateDrawable();
    }

    public void setImageBitmap(Bitmap bm) {
        this.mResource = 0;
        this.mDrawable = RoundedCornerDrawable.fromBitmap(bm, this.getResources());
        super.setImageDrawable(this.mDrawable);
        this.updateDrawable();
    }

    public void setImageResource(int resId) {
        if (this.mResource != resId) {
            this.mResource = resId;
            this.mDrawable = this.resolveResource();
            super.setImageDrawable(this.mDrawable);
            this.updateDrawable();
        }
    }

    public void setImageURI(Uri uri) {
        super.setImageURI(uri);
        this.setImageDrawable(this.getDrawable());
    }

    public void setCorners(@DimenRes int leftTop, @DimenRes int rightTop, @DimenRes int rightBottom, @DimenRes int leftBottom) {
        this.setCorners(leftTop == 0 ? 0.0f : this.getResources().getDimension(leftTop), rightTop == 0 ? 0.0f : this.getResources().getDimension(rightTop), rightBottom == 0 ? 0.0f : this.getResources().getDimension(rightBottom), leftBottom == 0 ? 0.0f : this.getResources().getDimension(leftBottom));
    }

    public void setCorners(float leftTop, float rightTop, float rightBottom, float leftBottom) {
        this.mRadii = new float[]{leftTop, leftTop, rightTop, rightTop, rightBottom, rightBottom, leftBottom, leftBottom};
        this.updateDrawable();
    }

    private Drawable resolveResource() {
        Drawable d = null;
        if (this.mResource != 0) {
            try {
                d = ContextCompat.getDrawable((Context)this.getContext(), (int)this.mResource);
            }
            catch (Resources.NotFoundException e) {
                this.mResource = 0;
            }
        }
        return RoundedCornerDrawable.fromDrawable(d, this.getResources());
    }

    private void updateDrawable() {
        if (this.mDrawable == null) {
            return;
        }
        ((RoundedCornerDrawable)this.mDrawable).setCornerRadii(this.mRadii);
    }

    private static class RoundedCornerDrawable
    extends Drawable {
        private RectF mBounds = new RectF();
        private final RectF mBitmapRect = new RectF();
        private final int mBitmapWidth;
        private final int mBitmapHeight;
        private final Paint mBitmapPaint;
        private BitmapShader mBitmapShader;
        private float[] mRadii = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        private Path mPath = new Path();
        private Bitmap mBitmap;
        private boolean mBoundsConfigured = false;

        private RoundedCornerDrawable(Bitmap bitmap, Resources r) {
            this.mBitmap = bitmap;
            this.mBitmapShader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            this.mBitmapWidth = bitmap.getScaledWidth(r.getDisplayMetrics());
            this.mBitmapHeight = bitmap.getScaledHeight(r.getDisplayMetrics());
            this.mBitmapRect.set(0.0f, 0.0f, (float)this.mBitmapWidth, (float)this.mBitmapHeight);
            this.mBitmapPaint = new Paint(1);
            this.mBitmapPaint.setStyle(Paint.Style.FILL);
            this.mBitmapPaint.setShader((Shader)this.mBitmapShader);
        }

        private static RoundedCornerDrawable fromBitmap(Bitmap bitmap, Resources r) {
            if (bitmap != null) {
                return new RoundedCornerDrawable(bitmap, r);
            }
            return null;
        }

        private static Drawable fromDrawable(Drawable drawable2, Resources r) {
            if (drawable2 != null) {
                if (drawable2 instanceof RoundedCornerDrawable) {
                    return drawable2;
                }
                if (drawable2 instanceof LayerDrawable) {
                    LayerDrawable ld = (LayerDrawable)drawable2;
                    int num = ld.getNumberOfLayers();
                    for (int i = 0; i < num; ++i) {
                        Drawable d = ld.getDrawable(i);
                        ld.setDrawableByLayerId(ld.getId(i), RoundedCornerDrawable.fromDrawable(d, r));
                    }
                    return ld;
                }
                Bitmap bm = RoundedCornerDrawable.drawableToBitmap(drawable2);
                if (bm != null) {
                    return new RoundedCornerDrawable(bm, r);
                }
            }
            return drawable2;
        }

        private static Bitmap drawableToBitmap(Drawable drawable2) {
            Bitmap bitmap;
            if (drawable2 == null) {
                return null;
            }
            if (drawable2 instanceof BitmapDrawable) {
                return ((BitmapDrawable)drawable2).getBitmap();
            }
            int width = Math.max(drawable2.getIntrinsicWidth(), 2);
            int height = Math.max(drawable2.getIntrinsicHeight(), 2);
            try {
                bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
                drawable2.draw(canvas);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                bitmap = null;
            }
            return bitmap;
        }

        private void configureBounds(Canvas canvas) {
            Matrix canvasMatrix = canvas.getMatrix();
            this.applyScaleToRadii(canvasMatrix);
            this.mBounds.set(this.mBitmapRect);
        }

        private void applyScaleToRadii(Matrix m) {
            float[] values = new float[9];
            m.getValues(values);
            for (int i = 0; i < this.mRadii.length; ++i) {
                this.mRadii[i] = this.mRadii[i] / values[0];
            }
        }

        public void draw(@NonNull Canvas canvas) {
            canvas.save();
            if (!this.mBoundsConfigured) {
                this.configureBounds(canvas);
                this.mBoundsConfigured = true;
            }
            this.mPath.addRoundRect(this.mBounds, this.mRadii, Path.Direction.CW);
            canvas.drawPath(this.mPath, this.mBitmapPaint);
            canvas.restore();
        }

        void setCornerRadii(float[] radii) {
            if (radii == null) {
                return;
            }
            if (radii.length != 8) {
                throw new ArrayIndexOutOfBoundsException("radii[] needs 8 values");
            }
            System.arraycopy(radii, 0, this.mRadii, 0, radii.length);
        }

        public int getOpacity() {
            return this.mBitmap == null || this.mBitmap.hasAlpha() || this.mBitmapPaint.getAlpha() < 255 ? -3 : -1;
        }

        public void setAlpha(int alpha) {
            this.mBitmapPaint.setAlpha(alpha);
            this.invalidateSelf();
        }

        public void setColorFilter(ColorFilter cf) {
            this.mBitmapPaint.setColorFilter(cf);
            this.invalidateSelf();
        }

        public void setDither(boolean dither) {
            this.mBitmapPaint.setDither(dither);
            this.invalidateSelf();
        }

        public void setFilterBitmap(boolean filter) {
            this.mBitmapPaint.setFilterBitmap(filter);
            this.invalidateSelf();
        }

        public int getIntrinsicWidth() {
            return this.mBitmapWidth;
        }

        public int getIntrinsicHeight() {
            return this.mBitmapHeight;
        }
    }
}

