/*
 * Decompiled with CFR 0.152.
 */
package io.skygear.chatkit.messages;

import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;

class RecyclerScrollMoreListener
extends RecyclerView.OnScrollListener {
    private OnLoadMoreListener loadMoreListener;
    private boolean listening = false;
    private RecyclerView.LayoutManager mLayoutManager;

    RecyclerScrollMoreListener(LinearLayoutManager layoutManager, OnLoadMoreListener loadMoreListener) {
        this.mLayoutManager = layoutManager;
        this.loadMoreListener = loadMoreListener;
    }

    private int getLastVisibleItem(int[] lastVisibleItemPositions) {
        int maxSize = 0;
        for (int i = 0; i < lastVisibleItemPositions.length; ++i) {
            if (i == 0) {
                maxSize = lastVisibleItemPositions[i];
                continue;
            }
            if (lastVisibleItemPositions[i] <= maxSize) continue;
            maxSize = lastVisibleItemPositions[i];
        }
        return maxSize;
    }

    private int getLastVisibleItemPosition() {
        int lastVisibleItemPosition = 0;
        if (this.mLayoutManager instanceof StaggeredGridLayoutManager) {
            int[] lastVisibleItemPositions = ((StaggeredGridLayoutManager)this.mLayoutManager).findLastVisibleItemPositions(null);
            lastVisibleItemPosition = this.getLastVisibleItem(lastVisibleItemPositions);
        } else if (this.mLayoutManager instanceof LinearLayoutManager) {
            lastVisibleItemPosition = ((LinearLayoutManager)this.mLayoutManager).findLastVisibleItemPosition();
        } else if (this.mLayoutManager instanceof GridLayoutManager) {
            lastVisibleItemPosition = ((GridLayoutManager)this.mLayoutManager).findLastVisibleItemPosition();
        }
        return lastVisibleItemPosition;
    }

    private boolean shouldTriggerLoadMore() {
        int visibleThreshold = 5;
        int lastVisibleItemPosition = this.getLastVisibleItemPosition();
        int totalItemCount = this.mLayoutManager.getItemCount();
        return this.listening && lastVisibleItemPosition + visibleThreshold > totalItemCount;
    }

    private void triggerLoadMore() {
        int totalItemCount = this.mLayoutManager.getItemCount();
        this.loadMoreListener.onLoadMore(totalItemCount);
    }

    public void onScrolled(RecyclerView view, int dx, int dy) {
        if (this.loadMoreListener != null && this.shouldTriggerLoadMore()) {
            this.triggerLoadMore();
        }
    }

    public void startListening() {
        this.listening = true;
        if (this.shouldTriggerLoadMore()) {
            this.triggerLoadMore();
        }
    }

    public void stopListening() {
        this.listening = false;
    }

    static interface OnLoadMoreListener {
        public void onLoadMore(int var1);
    }
}

