/*
 * Decompiled with CFR 0.152.
 */
package io.skygear.chatkit.messages;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import io.skygear.chatkit.commons.models.IMessage;
import io.skygear.chatkit.messages.MessagesListAdapter;
import io.skygear.chatkit.messages.MessagesListStyle;
import io.skygear.chatkit.messages.RecyclerScrollMoreListener;
import java.lang.ref.WeakReference;

public class MessagesList
extends RecyclerView {
    private MessagesListStyle messagesListStyle;

    public MessagesList(Context context) {
        super(context);
    }

    public MessagesList(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.parseStyle(context, attrs);
    }

    public MessagesList(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.parseStyle(context, attrs);
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        throw new IllegalArgumentException("You can't set adapter to MessagesList. Use #setAdapter(MessagesListAdapter) instead.");
    }

    public <MESSAGE extends IMessage> void setAdapter(MessagesListAdapter<MESSAGE> adapter) {
        this.setAdapter(adapter, true);
    }

    public <MESSAGE extends IMessage> void setAdapter(MessagesListAdapter<MESSAGE> adapter, boolean reverseLayout) {
        DefaultItemAnimator itemAnimator = new DefaultItemAnimator();
        itemAnimator.setSupportsChangeAnimations(false);
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext(), 1, reverseLayout);
        this.setItemAnimator((RecyclerView.ItemAnimator)itemAnimator);
        this.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        adapter.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        adapter.setStyle(this.messagesListStyle);
        RecyclerScrollMoreListener listener = new RecyclerScrollMoreListener(layoutManager, adapter);
        adapter.scrollMoreListener = new WeakReference<RecyclerScrollMoreListener>(listener);
        this.addOnScrollListener(listener);
        super.setAdapter(adapter);
    }

    private void parseStyle(Context context, AttributeSet attrs) {
        this.messagesListStyle = MessagesListStyle.parse(context, attrs);
    }
}

