/*
 * Decompiled with CFR 0.152.
 */
package io.skygear.chatkit.dialogs;

import android.content.Context;
import android.graphics.Typeface;
import android.graphics.drawable.GradientDrawable;
import android.support.annotation.LayoutRes;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import io.skygear.chatkit.R;
import io.skygear.chatkit.commons.ImageLoader;
import io.skygear.chatkit.commons.ViewHolder;
import io.skygear.chatkit.commons.models.IDialog;
import io.skygear.chatkit.commons.models.IMessage;
import io.skygear.chatkit.dialogs.DialogListStyle;
import io.skygear.chatkit.utils.DateFormatter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class DialogsListAdapter<DIALOG extends IDialog>
extends RecyclerView.Adapter<BaseDialogViewHolder> {
    private List<DIALOG> items = new ArrayList<DIALOG>();
    private int itemLayoutId;
    private Class<? extends BaseDialogViewHolder> holderClass;
    private ImageLoader imageLoader;
    private OnDialogClickListener<DIALOG> onDialogClickListener;
    private OnDialogViewClickListener<DIALOG> onDialogViewClickListener;
    private OnDialogLongClickListener<DIALOG> onLongItemClickListener;
    private OnDialogViewLongClickListener<DIALOG> onDialogViewLongClickListener;
    private DialogListStyle dialogStyle;
    private DateFormatter.Formatter datesFormatter;

    public DialogsListAdapter(ImageLoader imageLoader) {
        this(R.layout.item_dialog, DialogViewHolder.class, imageLoader);
    }

    public DialogsListAdapter(@LayoutRes int itemLayoutId, ImageLoader imageLoader) {
        this(itemLayoutId, DialogViewHolder.class, imageLoader);
    }

    public DialogsListAdapter(@LayoutRes int itemLayoutId, Class<? extends BaseDialogViewHolder> holderClass, ImageLoader imageLoader) {
        this.itemLayoutId = itemLayoutId;
        this.holderClass = holderClass;
        this.imageLoader = imageLoader;
    }

    public void onBindViewHolder(BaseDialogViewHolder holder, int position) {
        holder.setImageLoader(this.imageLoader);
        holder.setOnDialogClickListener(this.onDialogClickListener);
        holder.setOnDialogViewClickListener(this.onDialogViewClickListener);
        holder.setOnLongItemClickListener(this.onLongItemClickListener);
        holder.setOnDialogViewLongClickListener(this.onDialogViewLongClickListener);
        holder.setDatesFormatter(this.datesFormatter);
        holder.onBind(this.items.get(position));
    }

    public BaseDialogViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(this.itemLayoutId, parent, false);
        try {
            Constructor<? extends BaseDialogViewHolder> constructor = this.holderClass.getDeclaredConstructor(View.class);
            constructor.setAccessible(true);
            BaseDialogViewHolder baseDialogViewHolder = constructor.newInstance(v);
            if (baseDialogViewHolder instanceof DialogViewHolder) {
                ((DialogViewHolder)baseDialogViewHolder).setDialogStyle(this.dialogStyle);
            }
            return baseDialogViewHolder;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getItemCount() {
        return this.items.size();
    }

    public void deleteById(String id2) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!((IDialog)this.items.get(i)).getId().equals(id2)) continue;
            this.items.remove(i);
            this.notifyItemRemoved(i);
        }
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public void clear() {
        if (this.items != null) {
            this.items.clear();
        }
        this.notifyDataSetChanged();
    }

    public void setItems(List<DIALOG> items) {
        this.items = items;
        this.notifyDataSetChanged();
    }

    public void addItems(List<DIALOG> newItems) {
        if (newItems != null) {
            if (this.items == null) {
                this.items = new ArrayList<DIALOG>();
            }
            int curSize = this.items.size();
            this.items.addAll(newItems);
            this.notifyItemRangeInserted(curSize, this.items.size());
        }
    }

    public void addItem(DIALOG dialog) {
        this.items.add(dialog);
        this.notifyItemInserted(0);
    }

    public void addItem(int position, DIALOG dialog) {
        this.items.add(position, dialog);
        this.notifyItemInserted(position);
    }

    public void updateItem(int position, DIALOG item) {
        if (this.items == null) {
            this.items = new ArrayList<DIALOG>();
        }
        this.items.set(position, item);
        this.notifyItemChanged(position);
    }

    public void updateItemById(DIALOG item) {
        if (this.items == null) {
            this.items = new ArrayList<DIALOG>();
        }
        for (int i = 0; i < this.items.size(); ++i) {
            if (!((IDialog)this.items.get(i)).getId().equals(item.getId())) continue;
            this.items.set(i, item);
            this.notifyItemChanged(i);
            break;
        }
    }

    public boolean updateDialogWithMessage(String dialogId, IMessage message) {
        boolean dialogExist = false;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!((IDialog)this.items.get(i)).getId().equals(dialogId)) continue;
            ((IDialog)this.items.get(i)).setLastMessage(message);
            this.notifyItemChanged(i);
            if (i != 0) {
                Collections.swap(this.items, i, 0);
                this.notifyItemMoved(i, 0);
            }
            dialogExist = true;
            break;
        }
        return dialogExist;
    }

    public void sortByLastMessageDate() {
        Collections.sort(this.items, new Comparator<DIALOG>(){

            @Override
            public int compare(DIALOG o1, DIALOG o2) {
                if (o1.getLastMessage().getCreatedAt().after(o2.getLastMessage().getCreatedAt())) {
                    return -1;
                }
                if (o1.getLastMessage().getCreatedAt().before(o2.getLastMessage().getCreatedAt())) {
                    return 1;
                }
                return 0;
            }
        });
        this.notifyDataSetChanged();
    }

    public void sort(Comparator<DIALOG> comparator) {
        Collections.sort(this.items, comparator);
        this.notifyDataSetChanged();
    }

    public void setImageLoader(ImageLoader imageLoader) {
        this.imageLoader = imageLoader;
    }

    public ImageLoader getImageLoader() {
        return this.imageLoader;
    }

    public OnDialogClickListener getOnDialogClickListener() {
        return this.onDialogClickListener;
    }

    public void setOnDialogClickListener(OnDialogClickListener<DIALOG> onDialogClickListener) {
        this.onDialogClickListener = onDialogClickListener;
    }

    public OnDialogViewClickListener getOnDialogViewClickListener() {
        return this.onDialogViewClickListener;
    }

    public void setOnDialogViewClickListener(OnDialogViewClickListener<DIALOG> clickListener) {
        this.onDialogViewClickListener = clickListener;
    }

    public OnDialogLongClickListener getOnLongItemClickListener() {
        return this.onLongItemClickListener;
    }

    public void setOnDialogLongClickListener(OnDialogLongClickListener<DIALOG> onLongItemClickListener) {
        this.onLongItemClickListener = onLongItemClickListener;
    }

    public OnDialogViewLongClickListener<DIALOG> getOnDialogViewLongClickListener() {
        return this.onDialogViewLongClickListener;
    }

    public void setOnDialogViewLongClickListener(OnDialogViewLongClickListener<DIALOG> clickListener) {
        this.onDialogViewLongClickListener = clickListener;
    }

    public void setDatesFormatter(DateFormatter.Formatter datesFormatter) {
        this.datesFormatter = datesFormatter;
    }

    void setStyle(DialogListStyle dialogStyle) {
        this.dialogStyle = dialogStyle;
    }

    public static class DialogViewHolder<DIALOG extends IDialog>
    extends BaseDialogViewHolder<DIALOG> {
        protected DialogListStyle dialogStyle;
        protected ViewGroup container;
        protected ViewGroup root;
        protected TextView tvName;
        protected TextView tvDate;
        protected ImageView ivAvatar;
        protected ImageView ivLastMessageUser;
        protected TextView tvLastMessage;
        protected TextView tvBubble;
        protected ViewGroup dividerContainer;
        protected View divider;

        public DialogViewHolder(View itemView) {
            super(itemView);
            this.root = (ViewGroup)itemView.findViewById(R.id.dialogRootLayout);
            this.container = (ViewGroup)itemView.findViewById(R.id.dialogContainer);
            this.tvName = (TextView)itemView.findViewById(R.id.dialogName);
            this.tvDate = (TextView)itemView.findViewById(R.id.dialogDate);
            this.tvLastMessage = (TextView)itemView.findViewById(R.id.dialogLastMessage);
            this.tvBubble = (TextView)itemView.findViewById(R.id.dialogUnreadBubble);
            this.ivLastMessageUser = (ImageView)itemView.findViewById(R.id.dialogLastMessageUserAvatar);
            this.ivAvatar = (ImageView)itemView.findViewById(R.id.dialogAvatar);
            this.dividerContainer = (ViewGroup)itemView.findViewById(R.id.dialogDividerContainer);
            this.divider = itemView.findViewById(R.id.dialogDivider);
        }

        private void applyStyle() {
            if (this.dialogStyle != null) {
                if (this.tvName != null) {
                    this.tvName.setTextSize(0, (float)this.dialogStyle.getDialogTitleTextSize());
                }
                if (this.tvLastMessage != null) {
                    this.tvLastMessage.setTextSize(0, (float)this.dialogStyle.getDialogMessageTextSize());
                }
                if (this.tvDate != null) {
                    this.tvDate.setTextSize(0, (float)this.dialogStyle.getDialogDateSize());
                }
                if (this.divider != null) {
                    this.divider.setBackgroundColor(this.dialogStyle.getDialogDividerColor());
                }
                if (this.dividerContainer != null) {
                    this.dividerContainer.setPadding(this.dialogStyle.getDialogDividerLeftPadding(), 0, this.dialogStyle.getDialogDividerRightPadding(), 0);
                }
                if (this.ivAvatar != null) {
                    this.ivAvatar.getLayoutParams().width = this.dialogStyle.getDialogAvatarWidth();
                    this.ivAvatar.getLayoutParams().height = this.dialogStyle.getDialogAvatarHeight();
                }
                if (this.ivLastMessageUser != null) {
                    this.ivLastMessageUser.getLayoutParams().width = this.dialogStyle.getDialogMessageAvatarWidth();
                    this.ivLastMessageUser.getLayoutParams().height = this.dialogStyle.getDialogMessageAvatarHeight();
                }
                if (this.tvBubble != null) {
                    GradientDrawable bgShape = (GradientDrawable)this.tvBubble.getBackground();
                    bgShape.setColor(this.dialogStyle.getDialogUnreadBubbleBackgroundColor());
                    this.tvBubble.setVisibility(this.dialogStyle.isDialogDividerEnabled() ? 0 : 8);
                    this.tvBubble.setTextSize(0, (float)this.dialogStyle.getDialogUnreadBubbleTextSize());
                    this.tvBubble.setTextColor(this.dialogStyle.getDialogUnreadBubbleTextColor());
                    this.tvBubble.setTypeface(this.tvBubble.getTypeface(), this.dialogStyle.getDialogUnreadBubbleTextStyle());
                }
            }
        }

        private void applyDefaultStyle() {
            if (this.dialogStyle != null) {
                if (this.root != null) {
                    this.root.setBackgroundColor(this.dialogStyle.getDialogItemBackground());
                }
                if (this.tvName != null) {
                    this.tvName.setTextColor(this.dialogStyle.getDialogTitleTextColor());
                    this.tvName.setTypeface(Typeface.DEFAULT, this.dialogStyle.getDialogTitleTextStyle());
                }
                if (this.tvDate != null) {
                    this.tvDate.setTextColor(this.dialogStyle.getDialogDateColor());
                    this.tvDate.setTypeface(Typeface.DEFAULT, this.dialogStyle.getDialogDateStyle());
                }
                if (this.tvLastMessage != null) {
                    this.tvLastMessage.setTextColor(this.dialogStyle.getDialogMessageTextColor());
                    this.tvLastMessage.setTypeface(Typeface.DEFAULT, this.dialogStyle.getDialogMessageTextStyle());
                }
            }
        }

        private void applyUnreadStyle() {
            if (this.dialogStyle != null) {
                if (this.root != null) {
                    this.root.setBackgroundColor(this.dialogStyle.getDialogUnreadItemBackground());
                }
                if (this.tvName != null) {
                    this.tvName.setTextColor(this.dialogStyle.getDialogUnreadTitleTextColor());
                    this.tvName.setTypeface(Typeface.DEFAULT, this.dialogStyle.getDialogUnreadTitleTextStyle());
                }
                if (this.tvDate != null) {
                    this.tvDate.setTextColor(this.dialogStyle.getDialogUnreadDateColor());
                    this.tvDate.setTypeface(Typeface.DEFAULT, this.dialogStyle.getDialogUnreadDateStyle());
                }
                if (this.tvLastMessage != null) {
                    this.tvLastMessage.setTextColor(this.dialogStyle.getDialogUnreadMessageTextColor());
                    this.tvLastMessage.setTypeface(Typeface.DEFAULT, this.dialogStyle.getDialogUnreadMessageTextStyle());
                }
            }
        }

        @Override
        public void onBind(DIALOG dialog) {
            if (dialog.getUnreadCount() > 0) {
                this.applyUnreadStyle();
            } else {
                this.applyDefaultStyle();
            }
            this.tvName.setText((CharSequence)dialog.getDialogName());
            String formattedDate = null;
            Date lastMessageDate = dialog.getLastMessage().getCreatedAt();
            if (this.datesFormatter != null) {
                formattedDate = this.datesFormatter.format(lastMessageDate);
            }
            this.tvDate.setText((CharSequence)(formattedDate == null ? this.getDateString(lastMessageDate) : formattedDate));
            if (this.imageLoader != null) {
                this.imageLoader.loadImage(this.ivAvatar, dialog.getDialogPhoto());
            }
            if (this.imageLoader != null) {
                this.imageLoader.loadImage(this.ivLastMessageUser, dialog.getLastMessage().getUser().getAvatar());
            }
            this.ivLastMessageUser.setVisibility(this.dialogStyle.isDialogMessageAvatarEnabled() && dialog.getUsers().size() > 1 ? 0 : 8);
            this.tvLastMessage.setText((CharSequence)dialog.getLastMessage().getText());
            this.tvBubble.setText((CharSequence)String.valueOf(dialog.getUnreadCount()));
            this.tvBubble.setVisibility(this.dialogStyle.isDialogUnreadBubbleEnabled() && dialog.getUnreadCount() > 0 ? 0 : 8);
            this.container.setOnClickListener(new View.OnClickListener((IDialog)dialog){
                final /* synthetic */ IDialog val$dialog;
                {
                    this.val$dialog = iDialog;
                }

                public void onClick(View view) {
                    if (DialogViewHolder.this.onDialogClickListener != null) {
                        DialogViewHolder.this.onDialogClickListener.onDialogClick(this.val$dialog);
                    }
                    if (DialogViewHolder.this.onDialogViewClickListener != null) {
                        DialogViewHolder.this.onDialogViewClickListener.onDialogViewClick(view, this.val$dialog);
                    }
                }
            });
            this.container.setOnLongClickListener(new View.OnLongClickListener((IDialog)dialog){
                final /* synthetic */ IDialog val$dialog;
                {
                    this.val$dialog = iDialog;
                }

                public boolean onLongClick(View view) {
                    if (DialogViewHolder.this.onLongItemClickListener != null) {
                        DialogViewHolder.this.onLongItemClickListener.onDialogLongClick(this.val$dialog);
                    }
                    if (DialogViewHolder.this.onDialogViewLongClickListener != null) {
                        DialogViewHolder.this.onDialogViewLongClickListener.onDialogViewLongClick(view, this.val$dialog);
                    }
                    return DialogViewHolder.this.onLongItemClickListener != null || DialogViewHolder.this.onDialogViewLongClickListener != null;
                }
            });
        }

        protected String getDateString(Date date) {
            return DateFormatter.format(date, DateFormatter.Template.TIME);
        }

        protected DialogListStyle getDialogStyle() {
            return this.dialogStyle;
        }

        protected void setDialogStyle(DialogListStyle dialogStyle) {
            this.dialogStyle = dialogStyle;
            this.applyStyle();
        }
    }

    public static abstract class BaseDialogViewHolder<DIALOG extends IDialog>
    extends ViewHolder<DIALOG> {
        protected ImageLoader imageLoader;
        protected OnDialogClickListener<DIALOG> onDialogClickListener;
        protected OnDialogLongClickListener<DIALOG> onLongItemClickListener;
        protected OnDialogViewClickListener<DIALOG> onDialogViewClickListener;
        protected OnDialogViewLongClickListener<DIALOG> onDialogViewLongClickListener;
        protected DateFormatter.Formatter datesFormatter;

        public BaseDialogViewHolder(View itemView) {
            super(itemView);
        }

        void setImageLoader(ImageLoader imageLoader) {
            this.imageLoader = imageLoader;
        }

        protected void setOnDialogClickListener(OnDialogClickListener<DIALOG> onDialogClickListener) {
            this.onDialogClickListener = onDialogClickListener;
        }

        protected void setOnDialogViewClickListener(OnDialogViewClickListener<DIALOG> onDialogViewClickListener) {
            this.onDialogViewClickListener = onDialogViewClickListener;
        }

        protected void setOnLongItemClickListener(OnDialogLongClickListener<DIALOG> onLongItemClickListener) {
            this.onLongItemClickListener = onLongItemClickListener;
        }

        protected void setOnDialogViewLongClickListener(OnDialogViewLongClickListener<DIALOG> onDialogViewLongClickListener) {
            this.onDialogViewLongClickListener = onDialogViewLongClickListener;
        }

        public void setDatesFormatter(DateFormatter.Formatter dateHeadersFormatter) {
            this.datesFormatter = dateHeadersFormatter;
        }
    }

    public static interface OnDialogViewLongClickListener<DIALOG extends IDialog> {
        public void onDialogViewLongClick(View var1, DIALOG var2);
    }

    public static interface OnDialogLongClickListener<DIALOG extends IDialog> {
        public void onDialogLongClick(DIALOG var1);
    }

    public static interface OnDialogViewClickListener<DIALOG extends IDialog> {
        public void onDialogViewClick(View var1, DIALOG var2);
    }

    public static interface OnDialogClickListener<DIALOG extends IDialog> {
        public void onDialogClick(DIALOG var1);
    }
}

