/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.graphql;

import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.graphql.SentryGraphqlInstrumentation;
import io.sentry.graphql.SentryInstrumentation;
import io.sentry.graphql.SentrySubscriptionHandler;
import io.sentry.spring.graphql.SentryDataFetcherExceptionResolverAdapter;
import io.sentry.spring.graphql.SentryGraphqlBeanPostProcessor;
import io.sentry.spring.graphql.SentrySpringSubscriptionHandler;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration(proxyBeanMethods=false)
public class SentryGraphqlConfiguration {
    @Bean(name={"sentryInstrumentation"})
    @ConditionalOnMissingBean
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    public SentryInstrumentation sentryInstrumentationWebMvc(@NotNull ObjectProvider<SentryGraphqlInstrumentation.BeforeSpanCallback> beforeSpanCallback) {
        SentryIntegrationPackageStorage.getInstance().addIntegration("Spring5GrahQLWebMVC");
        return this.createInstrumentation(beforeSpanCallback, false);
    }

    @Bean(name={"sentryInstrumentation"})
    @ConditionalOnMissingBean
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    public SentryInstrumentation sentryInstrumentationWebflux(@NotNull ObjectProvider<SentryGraphqlInstrumentation.BeforeSpanCallback> beforeSpanCallback) {
        SentryIntegrationPackageStorage.getInstance().addIntegration("Spring5GrahQLWebFlux");
        return this.createInstrumentation(beforeSpanCallback, true);
    }

    private SentryInstrumentation createInstrumentation(@NotNull ObjectProvider<SentryGraphqlInstrumentation.BeforeSpanCallback> beforeSpanCallback, boolean captureRequestBody) {
        return new SentryInstrumentation((SentryGraphqlInstrumentation.BeforeSpanCallback)beforeSpanCallback.getIfAvailable(), (SentrySubscriptionHandler)new SentrySpringSubscriptionHandler(), captureRequestBody);
    }

    @Bean
    @Order(value=-2147483648)
    public SentryDataFetcherExceptionResolverAdapter exceptionResolverAdapter() {
        return new SentryDataFetcherExceptionResolverAdapter();
    }

    @Bean
    public SentryGraphqlBeanPostProcessor graphqlBeanPostProcessor() {
        return new SentryGraphqlBeanPostProcessor();
    }
}

