/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.tracing;

import io.sentry.CustomSamplingContext;
import io.sentry.IScopes;
import io.sentry.ITransaction;
import io.sentry.ScopesAdapter;
import io.sentry.SpanStatus;
import io.sentry.TransactionContext;
import io.sentry.TransactionOptions;
import io.sentry.protocol.TransactionNameSource;
import io.sentry.spring.tracing.SpringMvcTransactionNameProvider;
import io.sentry.spring.tracing.TransactionNameProvider;
import io.sentry.spring.tracing.TransactionNameWithSource;
import io.sentry.util.Objects;
import io.sentry.util.SpanUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpMethod;
import org.springframework.web.filter.OncePerRequestFilter;

public class SentryTracingFilter
extends OncePerRequestFilter {
    private static final String TRANSACTION_OP = "http.server";
    private static final String TRACE_ORIGIN = "auto.http.spring.webmvc";
    private static final String TRANSACTION_ATTR = "sentry.transaction";
    @NotNull
    private final TransactionNameProvider transactionNameProvider;
    @NotNull
    private final IScopes scopes;
    private final boolean isAsyncSupportEnabled;

    public SentryTracingFilter() {
        this((IScopes)ScopesAdapter.getInstance());
    }

    public SentryTracingFilter(@NotNull IScopes scopes, @NotNull TransactionNameProvider transactionNameProvider) {
        this(scopes, transactionNameProvider, false);
    }

    public SentryTracingFilter(@NotNull IScopes scopes, @NotNull TransactionNameProvider transactionNameProvider, boolean isAsyncSupportEnabled) {
        this.scopes = (IScopes)Objects.requireNonNull((Object)scopes, (String)"Scopes are required");
        this.transactionNameProvider = (TransactionNameProvider)Objects.requireNonNull((Object)transactionNameProvider, (String)"transactionNameProvider is required");
        this.isAsyncSupportEnabled = isAsyncSupportEnabled;
    }

    public SentryTracingFilter(@NotNull IScopes scopes) {
        this(scopes, new SpringMvcTransactionNameProvider());
    }

    protected boolean shouldNotFilterAsyncDispatch() {
        return !this.isAsyncSupportEnabled;
    }

    protected void doFilterInternal(@NotNull HttpServletRequest httpRequest, @NotNull HttpServletResponse httpResponse, @NotNull FilterChain filterChain) throws ServletException, IOException {
        if (this.scopes.isEnabled() && !this.isIgnored()) {
            TransactionContext transactionContext = null;
            if (this.shouldContinueTrace(httpRequest)) {
                @Nullable String sentryTraceHeader = httpRequest.getHeader("sentry-trace");
                @Nullable ArrayList<T> baggageHeader = Collections.list(httpRequest.getHeaders("baggage"));
                transactionContext = this.scopes.continueTrace(sentryTraceHeader, baggageHeader);
            }
            if (this.scopes.getOptions().isTracingEnabled() && this.shouldTraceRequest(httpRequest)) {
                this.doFilterWithTransaction(httpRequest, httpResponse, filterChain, transactionContext);
            } else {
                filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            }
        } else {
            filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
    }

    private boolean isIgnored() {
        return SpanUtils.isIgnored((List)this.scopes.getOptions().getIgnoredSpanOrigins(), (String)TRACE_ORIGIN);
    }

    private void doFilterWithTransaction(HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain filterChain, @Nullable TransactionContext transactionContext) throws IOException, ServletException {
        @Nullable ITransaction transaction = this.getOrStartTransaction(httpRequest, transactionContext);
        try {
            filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
        catch (Throwable e) {
            if (transaction != null) {
                transaction.setStatus(SpanStatus.INTERNAL_ERROR);
            }
            throw e;
        }
        finally {
            if (this.shouldFinishTransaction(httpRequest) && transaction != null) {
                @NotNull TransactionNameWithSource transactionNameWithSource = this.transactionNameProvider.provideTransactionNameAndSource(httpRequest);
                @Nullable String transactionName = transactionNameWithSource.getTransactionName();
                @NotNull TransactionNameSource transactionNameSource = transactionNameWithSource.getTransactionNameSource();
                if (transactionName != null) {
                    transaction.setName(transactionName, transactionNameSource);
                    transaction.setOperation(TRANSACTION_OP);
                    if (transaction.getStatus() == null) {
                        transaction.setStatus(SpanStatus.fromHttpStatusCode((int)httpResponse.getStatus()));
                    }
                    transaction.finish();
                }
            }
        }
    }

    private ITransaction getOrStartTransaction(@NotNull HttpServletRequest httpRequest, @Nullable TransactionContext transactionContext) {
        if (this.isAsyncDispatch(httpRequest)) {
            return (ITransaction)httpRequest.getAttribute(TRANSACTION_ATTR);
        }
        @NotNull ITransaction transaction = this.startTransaction(httpRequest, transactionContext);
        if (this.shouldStoreTransactionForAsyncProcessing()) {
            httpRequest.setAttribute(TRANSACTION_ATTR, (Object)transaction);
        }
        return transaction;
    }

    private boolean shouldContinueTrace(HttpServletRequest httpRequest) {
        return !this.isAsyncSupportEnabled || !this.isAsyncDispatch(httpRequest);
    }

    private boolean shouldStoreTransactionForAsyncProcessing() {
        return this.isAsyncSupportEnabled;
    }

    private boolean shouldFinishTransaction(HttpServletRequest httpRequest) {
        return !this.isAsyncSupportEnabled || !this.isAsyncStarted(httpRequest);
    }

    private boolean shouldTraceRequest(@NotNull HttpServletRequest request) {
        return this.scopes.getOptions().isTraceOptionsRequests() || !HttpMethod.OPTIONS.name().equals(request.getMethod());
    }

    private ITransaction startTransaction(@NotNull HttpServletRequest request, @Nullable TransactionContext transactionContext) {
        String name = request.getMethod() + " " + request.getRequestURI();
        CustomSamplingContext customSamplingContext = new CustomSamplingContext();
        customSamplingContext.set("request", (Object)request);
        TransactionOptions transactionOptions = new TransactionOptions();
        transactionOptions.setCustomSamplingContext(customSamplingContext);
        transactionOptions.setBindToScope(true);
        transactionOptions.setOrigin(TRACE_ORIGIN);
        if (transactionContext != null) {
            transactionContext.setName(name);
            transactionContext.setTransactionNameSource(TransactionNameSource.URL);
            transactionContext.setOperation(TRANSACTION_OP);
            return this.scopes.startTransaction(transactionContext, transactionOptions);
        }
        return this.scopes.startTransaction(new TransactionContext(name, TransactionNameSource.URL, TRANSACTION_OP), transactionOptions);
    }
}

