/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring;

import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.spring.CachedBodyHttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.util.StreamUtils;

final class RequestPayloadExtractor {
    RequestPayloadExtractor() {
    }

    @Nullable
    String extract(@NotNull HttpServletRequest request, @NotNull SentryOptions options) {
        if (request instanceof CachedBodyHttpServletRequest) {
            try {
                byte[] body = StreamUtils.copyToByteArray((InputStream)request.getInputStream());
                return new String(body, StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                options.getLogger().log(SentryLevel.ERROR, "Failed to set request body", (Throwable)e);
                return null;
            }
        }
        return null;
    }
}

