/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.graphql;

import graphql.GraphQLError;
import graphql.execution.DataFetcherExceptionHandlerResult;
import graphql.schema.DataFetchingEnvironment;
import io.sentry.graphql.SentryGraphqlExceptionHandler;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.graphql.execution.DataFetcherExceptionResolverAdapter;

@ApiStatus.Internal
public final class SentryDataFetcherExceptionResolverAdapter
extends DataFetcherExceptionResolverAdapter {
    @NotNull
    private final SentryGraphqlExceptionHandler handler = new SentryGraphqlExceptionHandler(null);

    public boolean isThreadLocalContextAware() {
        return true;
    }

    @Nullable
    protected GraphQLError resolveToSingleError(Throwable ex, DataFetchingEnvironment env) {
        List<GraphQLError> errors = this.resolveToMultipleErrors(ex, env);
        if (errors != null && !errors.isEmpty()) {
            return errors.get(0);
        }
        return null;
    }

    @Nullable
    protected List<GraphQLError> resolveToMultipleErrors(Throwable ex, DataFetchingEnvironment env) {
        @Nullable CompletableFuture result = this.handler.handleException(ex, env, null);
        if (result != null) {
            return ((DataFetcherExceptionHandlerResult)result.join()).getErrors();
        }
        return null;
    }
}

