/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.webflux;

import io.sentry.IHub;
import io.sentry.protocol.Request;
import io.sentry.util.HttpUtils;
import io.sentry.util.Objects;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;

@ApiStatus.Experimental
public class SentryRequestResolver {
    @NotNull
    private final IHub hub;

    public SentryRequestResolver(@NotNull IHub hub) {
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"options is required");
    }

    @NotNull
    public Request resolveSentryRequest(@NotNull ServerHttpRequest httpRequest) {
        Request sentryRequest = new Request();
        sentryRequest.setMethod(httpRequest.getMethodValue());
        sentryRequest.setQueryString(httpRequest.getURI().getQuery());
        sentryRequest.setUrl(httpRequest.getURI().toString());
        sentryRequest.setHeaders(this.resolveHeadersMap(httpRequest.getHeaders()));
        if (this.hub.getOptions().isSendDefaultPii()) {
            sentryRequest.setCookies(SentryRequestResolver.toString(httpRequest.getHeaders().get((Object)"Cookies")));
        }
        return sentryRequest;
    }

    @NotNull
    Map<String, String> resolveHeadersMap(HttpHeaders request) {
        HashMap<String, String> headersMap = new HashMap<String, String>();
        for (Map.Entry entry : request.entrySet()) {
            if (!this.hub.getOptions().isSendDefaultPii() && HttpUtils.containsSensitiveHeader((String)((String)entry.getKey()))) continue;
            headersMap.put((String)entry.getKey(), SentryRequestResolver.toString((List)entry.getValue()));
        }
        return headersMap;
    }

    @Nullable
    private static String toString(@Nullable List<String> enumeration) {
        return enumeration != null ? String.join((CharSequence)",", enumeration) : null;
    }
}

