/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring;

import io.sentry.IHub;
import io.sentry.Sentry;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.task.TaskDecorator;

public final class SentryTaskDecorator
implements TaskDecorator {
    @NotNull
    public Runnable decorate(@NotNull Runnable runnable) {
        IHub oldState = Sentry.getCurrentHub();
        IHub newHub = Sentry.getCurrentHub().clone();
        return () -> {
            Sentry.setCurrentHub((IHub)newHub);
            try {
                runnable.run();
            }
            finally {
                Sentry.setCurrentHub((IHub)oldState);
            }
        };
    }
}

