/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring;

import io.sentry.EventProcessor;
import io.sentry.SentryEvent;
import io.sentry.spring.tracing.TransactionNameProvider;
import io.sentry.util.Objects;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SentryRequestHttpServletRequestProcessor
implements EventProcessor {
    @NotNull
    private final TransactionNameProvider transactionNameProvider;
    @NotNull
    private final HttpServletRequest request;

    public SentryRequestHttpServletRequestProcessor(@NotNull TransactionNameProvider transactionNameProvider, @NotNull HttpServletRequest request) {
        this.transactionNameProvider = (TransactionNameProvider)Objects.requireNonNull((Object)transactionNameProvider, (String)"transactionNameProvider is required");
        this.request = (HttpServletRequest)Objects.requireNonNull((Object)request, (String)"request is required");
    }

    @NotNull
    public SentryEvent process(@NotNull SentryEvent event, @Nullable Map<String, Object> hint) {
        if (event.getTransaction() == null) {
            event.setTransaction(this.transactionNameProvider.provideTransactionName(this.request));
        }
        return event;
    }
}

