/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.webflux;

import io.sentry.IHub;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.exception.ExceptionMechanismException;
import io.sentry.protocol.Mechanism;
import io.sentry.spring.webflux.TransactionNameProvider;
import io.sentry.util.Objects;
import java.util.HashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.annotation.Order;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebExceptionHandler;
import reactor.core.publisher.Mono;

@Order(value=-2)
@ApiStatus.Experimental
public final class SentryWebExceptionHandler
implements WebExceptionHandler {
    @NotNull
    private final IHub hub;

    public SentryWebExceptionHandler(@NotNull IHub hub) {
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"hub is required");
    }

    @NotNull
    public Mono<Void> handle(@NotNull ServerWebExchange serverWebExchange, @NotNull Throwable ex) {
        if (!(ex instanceof ResponseStatusException)) {
            Mechanism mechanism = new Mechanism();
            mechanism.setType("SentryWebExceptionHandler");
            mechanism.setHandled(Boolean.valueOf(false));
            ExceptionMechanismException throwable = new ExceptionMechanismException(mechanism, ex, Thread.currentThread());
            SentryEvent event = new SentryEvent((Throwable)throwable);
            event.setLevel(SentryLevel.FATAL);
            event.setTransaction(TransactionNameProvider.provideTransactionName(serverWebExchange));
            HashMap<String, Object> hintMap = new HashMap<String, Object>();
            hintMap.put("webFluxExceptionHandler:request", serverWebExchange.getRequest());
            hintMap.put("webFluxExceptionHandler:response", serverWebExchange.getResponse());
            this.hub.captureEvent(event, hintMap);
        }
        return Mono.error((Throwable)ex);
    }
}

