/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.tracing;

import io.sentry.IHub;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.SentryTraceHeader;
import io.sentry.SentryTransaction;
import io.sentry.SpanStatus;
import io.sentry.TransactionContext;
import io.sentry.exception.InvalidSentryTraceHeaderException;
import io.sentry.spring.SentryRequestResolver;
import io.sentry.spring.tracing.TransactionNameProvider;
import io.sentry.util.Objects;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.filter.OncePerRequestFilter;

public class SentryTracingFilter
extends OncePerRequestFilter {
    private static final String TRANSACTION_OP = "http";
    @NotNull
    private final TransactionNameProvider transactionNameProvider = new TransactionNameProvider();
    @NotNull
    private final IHub hub;
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final SentryRequestResolver requestResolver;

    public SentryTracingFilter(@NotNull IHub hub, @NotNull SentryOptions options, @NotNull SentryRequestResolver requestResolver) {
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"hub is required");
        this.options = (SentryOptions)Objects.requireNonNull((Object)options, (String)"options is required");
        this.requestResolver = (SentryRequestResolver)Objects.requireNonNull((Object)requestResolver, (String)"requestResolver is required");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(@NotNull HttpServletRequest httpRequest, @NotNull HttpServletResponse httpResponse, @NotNull FilterChain filterChain) throws ServletException, IOException {
        String sentryTraceHeader = httpRequest.getHeader("sentry-trace");
        SentryTransaction transaction = this.startTransaction(httpRequest.getMethod() + " " + httpRequest.getRequestURI(), sentryTraceHeader);
        try {
            filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
        finally {
            String transactionName = this.transactionNameProvider.provideTransactionName(httpRequest);
            if (transactionName != null) {
                transaction.setName(transactionName);
                transaction.setOperation(TRANSACTION_OP);
                transaction.setRequest(this.requestResolver.resolveSentryRequest(httpRequest));
                transaction.setStatus(SpanStatus.fromHttpStatusCode((int)httpResponse.getStatus()));
                transaction.finish();
            }
        }
    }

    private SentryTransaction startTransaction(@NotNull String name, @Nullable String sentryTraceHeader) {
        if (sentryTraceHeader != null) {
            try {
                TransactionContext contexts = TransactionContext.fromSentryTrace((String)name, (SentryTraceHeader)new SentryTraceHeader(sentryTraceHeader));
                return this.hub.startTransaction(contexts);
            }
            catch (InvalidSentryTraceHeaderException e) {
                this.options.getLogger().log(SentryLevel.DEBUG, "Failed to parse Sentry trace header: %s", new Object[]{e.getMessage()});
            }
        }
        return this.hub.startTransaction(name);
    }
}

