/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring;

import io.sentry.IHub;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.exception.ExceptionMechanismException;
import io.sentry.protocol.Mechanism;
import io.sentry.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.Ordered;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

public class SentryExceptionResolver
implements HandlerExceptionResolver,
Ordered {
    @NotNull
    private final IHub hub;
    private final int order;

    public SentryExceptionResolver(@NotNull IHub hub, int order) {
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"hub is required");
        this.order = order;
    }

    @Nullable
    public ModelAndView resolveException(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @Nullable Object handler, @NotNull Exception ex) {
        Mechanism mechanism = new Mechanism();
        mechanism.setHandled(Boolean.valueOf(false));
        ExceptionMechanismException throwable = new ExceptionMechanismException(mechanism, (Throwable)ex, Thread.currentThread());
        SentryEvent event = new SentryEvent((Throwable)throwable);
        event.setLevel(SentryLevel.FATAL);
        this.hub.captureEvent(event);
        return null;
    }

    public int getOrder() {
        return this.order;
    }
}

