/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.jakarta;

import io.sentry.IScopes;
import io.sentry.IpAddressUtils;
import io.sentry.protocol.User;
import io.sentry.spring.jakarta.SentryUserProvider;
import io.sentry.util.Objects;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.springframework.web.filter.OncePerRequestFilter;

public class SentryUserFilter
extends OncePerRequestFilter {
    @NotNull
    private final IScopes scopes;
    @NotNull
    private final List<SentryUserProvider> sentryUserProviders;

    public SentryUserFilter(@NotNull IScopes scopes, @NotNull List<SentryUserProvider> sentryUserProviders) {
        this.scopes = (IScopes)Objects.requireNonNull((Object)scopes, (String)"scopes are required");
        this.sentryUserProviders = (List)Objects.requireNonNull(sentryUserProviders, (String)"sentryUserProviders list is required");
    }

    protected void doFilterInternal(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull FilterChain chain) throws ServletException, IOException {
        User user = new User();
        for (SentryUserProvider provider : this.sentryUserProviders) {
            this.apply(user, provider.provideUser());
        }
        if (this.scopes.getOptions().isSendDefaultPii() && IpAddressUtils.isDefault((String)user.getIpAddress())) {
            user.setIpAddress(null);
        }
        this.scopes.setUser(user);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void apply(@NotNull User existingUser, @Nullable User userFromProvider) {
        if (userFromProvider != null) {
            Optional.ofNullable(userFromProvider.getEmail()).ifPresent(arg_0 -> ((User)existingUser).setEmail(arg_0));
            Optional.ofNullable(userFromProvider.getId()).ifPresent(arg_0 -> ((User)existingUser).setId(arg_0));
            Optional.ofNullable(userFromProvider.getIpAddress()).ifPresent(arg_0 -> ((User)existingUser).setIpAddress(arg_0));
            Optional.ofNullable(userFromProvider.getUsername()).ifPresent(arg_0 -> ((User)existingUser).setUsername(arg_0));
            if (userFromProvider.getData() != null && !userFromProvider.getData().isEmpty()) {
                ConcurrentHashMap<String, String> existingUserData = existingUser.getData();
                if (existingUserData == null) {
                    existingUserData = new ConcurrentHashMap<String, String>();
                }
                for (Map.Entry entry : userFromProvider.getData().entrySet()) {
                    existingUserData.put((String)entry.getKey(), (String)entry.getValue());
                }
                existingUser.setData(existingUserData);
            }
        }
    }

    @VisibleForTesting
    @NotNull
    public List<SentryUserProvider> getSentryUserProviders() {
        return this.sentryUserProviders;
    }
}

