/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.jakarta.webflux;

import io.sentry.Breadcrumb;
import io.sentry.CustomSamplingContext;
import io.sentry.Hint;
import io.sentry.IScopes;
import io.sentry.ITransaction;
import io.sentry.NoOpScopes;
import io.sentry.Sentry;
import io.sentry.SpanStatus;
import io.sentry.TransactionContext;
import io.sentry.TransactionOptions;
import io.sentry.protocol.TransactionNameSource;
import io.sentry.spring.jakarta.webflux.SentryRequestResolver;
import io.sentry.spring.jakarta.webflux.TransactionNameProvider;
import io.sentry.util.Objects;
import io.sentry.util.SpanUtils;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;

@ApiStatus.Experimental
public abstract class AbstractSentryWebFilter
implements WebFilter {
    @NotNull
    private final SentryRequestResolver sentryRequestResolver;
    public static final String SENTRY_SCOPES_KEY = "sentry-scopes";
    @Deprecated
    public static final String SENTRY_HUB_KEY = "sentry-scopes";
    private static final String TRANSACTION_OP = "http.server";

    public AbstractSentryWebFilter(@NotNull IScopes scopes) {
        Objects.requireNonNull((Object)scopes, (String)"scopes are required");
        this.sentryRequestResolver = new SentryRequestResolver(scopes);
    }

    @Nullable
    protected ITransaction maybeStartTransaction(@NotNull IScopes requestScopes, @NotNull ServerHttpRequest request, @NotNull String origin) {
        if (requestScopes.isEnabled() && !this.isIgnored(requestScopes, origin)) {
            @NotNull HttpHeaders headers = request.getHeaders();
            @Nullable String sentryTraceHeader = headers.getFirst("sentry-trace");
            @Nullable List baggageHeaders = headers.get((Object)"baggage");
            @Nullable TransactionContext transactionContext = requestScopes.continueTrace(sentryTraceHeader, baggageHeaders);
            if (requestScopes.getOptions().isTracingEnabled() && this.shouldTraceRequest(requestScopes, request)) {
                return this.startTransaction(requestScopes, request, transactionContext, origin);
            }
        }
        return null;
    }

    private boolean isIgnored(@NotNull IScopes scopes, @NotNull String origin) {
        return SpanUtils.isIgnored((List)scopes.getOptions().getIgnoredSpanOrigins(), (String)origin);
    }

    protected void doFinally(@NotNull ServerWebExchange serverWebExchange, @NotNull IScopes requestScopes, @Nullable ITransaction transaction) {
        if (transaction != null) {
            this.finishTransaction(serverWebExchange, transaction);
        }
        Sentry.setCurrentScopes((IScopes)NoOpScopes.getInstance());
    }

    protected void doFirst(@NotNull ServerWebExchange serverWebExchange, @NotNull IScopes requestScopes) {
        if (requestScopes.isEnabled()) {
            serverWebExchange.getAttributes().put("sentry-scopes", requestScopes);
            ServerHttpRequest request = serverWebExchange.getRequest();
            ServerHttpResponse response = serverWebExchange.getResponse();
            Hint hint = new Hint();
            hint.set("webFluxFilter:request", (Object)request);
            hint.set("webFluxFilter:response", (Object)response);
            String methodName = request.getMethod() != null ? request.getMethod().name() : "unknown";
            requestScopes.addBreadcrumb(Breadcrumb.http((String)request.getURI().toString(), (String)methodName), hint);
            requestScopes.configureScope(scope -> scope.setRequest(this.sentryRequestResolver.resolveSentryRequest(request)));
        }
    }

    protected void doOnError(@Nullable ITransaction transaction, @NotNull Throwable e) {
        if (transaction != null) {
            transaction.setStatus(SpanStatus.INTERNAL_ERROR);
            transaction.setThrowable(e);
        }
    }

    protected boolean shouldTraceRequest(@NotNull IScopes scopes, @NotNull ServerHttpRequest request) {
        return scopes.getOptions().isTraceOptionsRequests() || !HttpMethod.OPTIONS.equals((Object)request.getMethod());
    }

    private void finishTransaction(ServerWebExchange exchange, ITransaction transaction) {
        HttpStatusCode statusCode;
        ServerHttpResponse response;
        String transactionName = TransactionNameProvider.provideTransactionName(exchange);
        if (transactionName != null) {
            transaction.setName(transactionName, TransactionNameSource.ROUTE);
            transaction.setOperation(TRANSACTION_OP);
        }
        if ((response = exchange.getResponse()) != null && (statusCode = response.getStatusCode()) != null) {
            transaction.getContexts().withResponse(sentryResponse -> sentryResponse.setStatusCode(Integer.valueOf(statusCode.value())));
            if (transaction.getStatus() == null) {
                transaction.setStatus(SpanStatus.fromHttpStatusCode((int)statusCode.value()));
            }
        }
        transaction.finish();
    }

    @NotNull
    protected ITransaction startTransaction(@NotNull IScopes scopes, @NotNull ServerHttpRequest request, @Nullable TransactionContext transactionContext, @NotNull String origin) {
        @NotNull String name = String.valueOf(request.getMethod()) + " " + request.getURI().getPath();
        @NotNull CustomSamplingContext customSamplingContext = new CustomSamplingContext();
        customSamplingContext.set("request", (Object)request);
        TransactionOptions transactionOptions = new TransactionOptions();
        transactionOptions.setCustomSamplingContext(customSamplingContext);
        transactionOptions.setBindToScope(true);
        transactionOptions.setOrigin(origin);
        if (transactionContext != null) {
            transactionContext.setName(name);
            transactionContext.setTransactionNameSource(TransactionNameSource.URL);
            transactionContext.setOperation(TRANSACTION_OP);
            return scopes.startTransaction(transactionContext, transactionOptions);
        }
        return scopes.startTransaction(new TransactionContext(name, TransactionNameSource.URL, TRANSACTION_OP), transactionOptions);
    }
}

