/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.jakarta;

import io.sentry.EventProcessor;
import io.sentry.Hint;
import io.sentry.SentryBaseEvent;
import io.sentry.SentryEvent;
import io.sentry.SentryReplayEvent;
import io.sentry.protocol.SentryTransaction;
import io.sentry.protocol.Spring;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.env.Environment;

public final class SpringProfilesEventProcessor
implements EventProcessor {
    @NotNull
    private final Environment environment;

    @NotNull
    public SentryEvent process(@NotNull SentryEvent event, @NotNull Hint hint) {
        this.processInternal((SentryBaseEvent)event);
        return event;
    }

    @NotNull
    public SentryTransaction process(@NotNull SentryTransaction transaction, @NotNull Hint hint) {
        this.processInternal((SentryBaseEvent)transaction);
        return transaction;
    }

    @NotNull
    public SentryReplayEvent process(@NotNull SentryReplayEvent event, @NotNull Hint hint) {
        this.processInternal((SentryBaseEvent)event);
        return event;
    }

    private void processInternal(@NotNull SentryBaseEvent event) {
        @Nullable String[] activeProfiles = this.environment.getActiveProfiles();
        @NotNull Spring springContext = new Spring();
        springContext.setActiveProfiles(activeProfiles);
        event.getContexts().setSpring(springContext);
    }

    public SpringProfilesEventProcessor(@NotNull Environment environment) {
        this.environment = environment;
    }
}

