/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.jakarta.tracing;

import io.sentry.protocol.TransactionNameSource;
import io.sentry.spring.jakarta.tracing.TransactionNameProvider;
import io.sentry.spring.jakarta.tracing.TransactionNameWithSource;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class CombinedTransactionNameProvider
implements TransactionNameProvider {
    @NotNull
    private final List<TransactionNameProvider> providers;

    public CombinedTransactionNameProvider(@NotNull List<TransactionNameProvider> providers) {
        this.providers = providers;
    }

    @Override
    @Nullable
    public String provideTransactionName(@NotNull HttpServletRequest request) {
        for (TransactionNameProvider provider : this.providers) {
            String transactionName = provider.provideTransactionName(request);
            if (transactionName == null) continue;
            return transactionName;
        }
        return null;
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public TransactionNameSource provideTransactionSource() {
        return TransactionNameSource.CUSTOM;
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public TransactionNameWithSource provideTransactionNameAndSource(@NotNull HttpServletRequest request) {
        for (TransactionNameProvider provider : this.providers) {
            String transactionName = provider.provideTransactionName(request);
            if (transactionName == null) continue;
            @NotNull TransactionNameSource source = provider.provideTransactionSource();
            return new TransactionNameWithSource(transactionName, source);
        }
        return new TransactionNameWithSource(null, TransactionNameSource.CUSTOM);
    }
}

