/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.jakarta.webflux;

import io.sentry.IScopes;
import io.sentry.ITransaction;
import io.sentry.Sentry;
import io.sentry.spring.jakarta.webflux.AbstractSentryWebFilter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@ApiStatus.Experimental
public class SentryWebFilter
extends AbstractSentryWebFilter {
    private static final String TRACE_ORIGIN = "auto.spring_jakarta.webflux";

    public SentryWebFilter(@NotNull IScopes scopes) {
        super(scopes);
    }

    public Mono<Void> filter(@NotNull ServerWebExchange serverWebExchange, @NotNull WebFilterChain webFilterChain) {
        @NotNull IScopes requestScopes = Sentry.forkedRootScopes((String)"request.webflux");
        ServerHttpRequest request = serverWebExchange.getRequest();
        @Nullable ITransaction transaction = this.maybeStartTransaction(requestScopes, request, TRACE_ORIGIN);
        return webFilterChain.filter(serverWebExchange).doFinally(__ -> this.doFinally(serverWebExchange, requestScopes, transaction)).doOnError(e -> this.doOnError(transaction, (Throwable)e)).doFirst(() -> {
            Sentry.setCurrentScopes((IScopes)requestScopes);
            this.doFirst(serverWebExchange, requestScopes);
        });
    }
}

