/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.jakarta.webflux;

import io.sentry.Breadcrumb;
import io.sentry.CustomSamplingContext;
import io.sentry.Hint;
import io.sentry.IHub;
import io.sentry.ITransaction;
import io.sentry.NoOpHub;
import io.sentry.Sentry;
import io.sentry.SpanStatus;
import io.sentry.TransactionContext;
import io.sentry.TransactionOptions;
import io.sentry.protocol.TransactionNameSource;
import io.sentry.spring.jakarta.webflux.SentryRequestResolver;
import io.sentry.spring.jakarta.webflux.TransactionNameProvider;
import io.sentry.util.Objects;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;

@ApiStatus.Experimental
public abstract class AbstractSentryWebFilter
implements WebFilter {
    @NotNull
    private final SentryRequestResolver sentryRequestResolver;
    public static final String SENTRY_HUB_KEY = "sentry-hub";
    private static final String TRANSACTION_OP = "http.server";

    public AbstractSentryWebFilter(@NotNull IHub hub) {
        Objects.requireNonNull((Object)hub, (String)"hub is required");
        this.sentryRequestResolver = new SentryRequestResolver(hub);
    }

    @Nullable
    protected ITransaction maybeStartTransaction(@NotNull IHub requestHub, @NotNull ServerHttpRequest request) {
        if (requestHub.isEnabled()) {
            @NotNull HttpHeaders headers = request.getHeaders();
            @Nullable String sentryTraceHeader = headers.getFirst("sentry-trace");
            @Nullable List baggageHeaders = headers.get((Object)"baggage");
            @Nullable TransactionContext transactionContext = requestHub.continueTrace(sentryTraceHeader, baggageHeaders);
            if (requestHub.getOptions().isTracingEnabled() && this.shouldTraceRequest(requestHub, request)) {
                return this.startTransaction(requestHub, request, transactionContext);
            }
        }
        return null;
    }

    protected void doFinally(@NotNull ServerWebExchange serverWebExchange, @NotNull IHub requestHub, @Nullable ITransaction transaction) {
        if (transaction != null) {
            this.finishTransaction(serverWebExchange, transaction);
        }
        if (requestHub.isEnabled()) {
            requestHub.popScope();
        }
        Sentry.setCurrentHub((IHub)NoOpHub.getInstance());
    }

    protected void doFirst(@NotNull ServerWebExchange serverWebExchange, @NotNull IHub requestHub) {
        if (requestHub.isEnabled()) {
            serverWebExchange.getAttributes().put(SENTRY_HUB_KEY, requestHub);
            requestHub.pushScope();
            ServerHttpRequest request = serverWebExchange.getRequest();
            ServerHttpResponse response = serverWebExchange.getResponse();
            Hint hint = new Hint();
            hint.set("webFluxFilter:request", (Object)request);
            hint.set("webFluxFilter:response", (Object)response);
            String methodName = request.getMethod() != null ? request.getMethod().name() : "unknown";
            requestHub.addBreadcrumb(Breadcrumb.http((String)request.getURI().toString(), (String)methodName), hint);
            requestHub.configureScope(scope -> scope.setRequest(this.sentryRequestResolver.resolveSentryRequest(request)));
        }
    }

    protected void doOnError(@Nullable ITransaction transaction, @NotNull Throwable e) {
        if (transaction != null) {
            transaction.setStatus(SpanStatus.INTERNAL_ERROR);
            transaction.setThrowable(e);
        }
    }

    protected boolean shouldTraceRequest(@NotNull IHub hub, @NotNull ServerHttpRequest request) {
        return hub.getOptions().isTraceOptionsRequests() || !HttpMethod.OPTIONS.equals((Object)request.getMethod());
    }

    private void finishTransaction(ServerWebExchange exchange, ITransaction transaction) {
        HttpStatusCode statusCode;
        ServerHttpResponse response;
        String transactionName = TransactionNameProvider.provideTransactionName(exchange);
        if (transactionName != null) {
            transaction.setName(transactionName, TransactionNameSource.ROUTE);
            transaction.setOperation(TRANSACTION_OP);
        }
        if ((response = exchange.getResponse()) != null && (statusCode = response.getStatusCode()) != null) {
            transaction.getContexts().withResponse(sentryResponse -> sentryResponse.setStatusCode(Integer.valueOf(statusCode.value())));
            if (transaction.getStatus() == null) {
                transaction.setStatus(SpanStatus.fromHttpStatusCode((int)statusCode.value()));
            }
        }
        transaction.finish();
    }

    @NotNull
    protected ITransaction startTransaction(@NotNull IHub hub, @NotNull ServerHttpRequest request, @Nullable TransactionContext transactionContext) {
        @NotNull String name = String.valueOf(request.getMethod()) + " " + request.getURI().getPath();
        @NotNull CustomSamplingContext customSamplingContext = new CustomSamplingContext();
        customSamplingContext.set("request", (Object)request);
        TransactionOptions transactionOptions = new TransactionOptions();
        transactionOptions.setCustomSamplingContext(customSamplingContext);
        transactionOptions.setBindToScope(true);
        if (transactionContext != null) {
            transactionContext.setName(name);
            transactionContext.setTransactionNameSource(TransactionNameSource.URL);
            transactionContext.setOperation(TRANSACTION_OP);
            return hub.startTransaction(transactionContext, transactionOptions);
        }
        return hub.startTransaction(new TransactionContext(name, TransactionNameSource.URL, TRANSACTION_OP), transactionOptions);
    }
}

