/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.jakarta;

import io.sentry.EventProcessor;
import io.sentry.HubAdapter;
import io.sentry.IHub;
import io.sentry.ITransportFactory;
import io.sentry.Integration;
import io.sentry.Sentry;
import io.sentry.SentryOptions;
import io.sentry.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SentryInitBeanPostProcessor
implements BeanPostProcessor,
ApplicationContextAware,
DisposableBean {
    @Nullable
    private ApplicationContext applicationContext;
    @NotNull
    private final IHub hub;

    public SentryInitBeanPostProcessor() {
        this((IHub)HubAdapter.getInstance());
    }

    SentryInitBeanPostProcessor(@NotNull IHub hub) {
        Objects.requireNonNull((Object)hub, (String)"hub is required");
        this.hub = hub;
    }

    @NotNull
    public Object postProcessAfterInitialization(@NotNull Object bean, @NotNull String beanName) throws BeansException {
        if (bean instanceof SentryOptions) {
            SentryOptions options = (SentryOptions)bean;
            if (this.applicationContext != null) {
                this.applicationContext.getBeanProvider(SentryOptions.TracesSamplerCallback.class).ifAvailable(arg_0 -> ((SentryOptions)options).setTracesSampler(arg_0));
                this.applicationContext.getBeanProvider(ITransportFactory.class).ifAvailable(arg_0 -> ((SentryOptions)options).setTransportFactory(arg_0));
                this.applicationContext.getBeanProvider(SentryOptions.BeforeSendCallback.class).ifAvailable(arg_0 -> ((SentryOptions)options).setBeforeSend(arg_0));
                this.applicationContext.getBeanProvider(SentryOptions.BeforeSendTransactionCallback.class).ifAvailable(arg_0 -> ((SentryOptions)options).setBeforeSendTransaction(arg_0));
                this.applicationContext.getBeanProvider(SentryOptions.BeforeBreadcrumbCallback.class).ifAvailable(arg_0 -> ((SentryOptions)options).setBeforeBreadcrumb(arg_0));
                this.applicationContext.getBeansOfType(EventProcessor.class).values().forEach(arg_0 -> ((SentryOptions)options).addEventProcessor(arg_0));
                this.applicationContext.getBeansOfType(Integration.class).values().forEach(arg_0 -> ((SentryOptions)options).addIntegration(arg_0));
                this.applicationContext.getBeanProvider(Sentry.OptionsConfiguration.class).ifAvailable(optionsConfiguration -> optionsConfiguration.configure(options));
            }
            Sentry.init((SentryOptions)options);
        }
        return bean;
    }

    public void setApplicationContext(@NotNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void destroy() {
        this.hub.close();
    }
}

