/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.jakarta.webflux;

import io.sentry.Breadcrumb;
import io.sentry.Hint;
import io.sentry.IHub;
import io.sentry.spring.jakarta.webflux.SentryRequestResolver;
import io.sentry.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;

@ApiStatus.Experimental
public abstract class AbstractSentryWebFilter
implements WebFilter {
    @NotNull
    private final SentryRequestResolver sentryRequestResolver;
    public static final String SENTRY_HUB_KEY = "sentry-hub";

    public AbstractSentryWebFilter(@NotNull IHub hub) {
        Objects.requireNonNull((Object)hub, (String)"hub is required");
        this.sentryRequestResolver = new SentryRequestResolver(hub);
    }

    protected void doFinally(@NotNull IHub requestHub) {
        requestHub.popScope();
    }

    protected void doFirst(@NotNull ServerWebExchange serverWebExchange, @NotNull IHub requestHub) {
        serverWebExchange.getAttributes().put(SENTRY_HUB_KEY, requestHub);
        requestHub.pushScope();
        ServerHttpRequest request = serverWebExchange.getRequest();
        ServerHttpResponse response = serverWebExchange.getResponse();
        Hint hint = new Hint();
        hint.set("webFluxFilter:request", (Object)request);
        hint.set("webFluxFilter:response", (Object)response);
        String methodName = request.getMethod() != null ? request.getMethod().name() : "unknown";
        requestHub.addBreadcrumb(Breadcrumb.http((String)request.getURI().toString(), (String)methodName), hint);
        requestHub.configureScope(scope -> scope.setRequest(this.sentryRequestResolver.resolveSentryRequest(request)));
    }
}

