/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.servlet;

import io.sentry.Breadcrumb;
import io.sentry.EventProcessor;
import io.sentry.HubAdapter;
import io.sentry.IHub;
import io.sentry.servlet.SentryRequestHttpServletRequestProcessor;
import io.sentry.util.Objects;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.NotNull;

public class SentryServletRequestListener
implements ServletRequestListener {
    private final IHub hub;

    public SentryServletRequestListener(@NotNull IHub hub) {
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"hub is required");
    }

    public SentryServletRequestListener() {
        this((IHub)HubAdapter.getInstance());
    }

    public void requestDestroyed(@NotNull ServletRequestEvent servletRequestEvent) {
        this.hub.popScope();
    }

    public void requestInitialized(@NotNull ServletRequestEvent servletRequestEvent) {
        this.hub.pushScope();
        ServletRequest servletRequest = servletRequestEvent.getServletRequest();
        if (servletRequest instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
            this.hub.addBreadcrumb(Breadcrumb.http((String)httpRequest.getRequestURI(), (String)httpRequest.getMethod()));
            this.hub.configureScope(scope -> scope.addEventProcessor((EventProcessor)new SentryRequestHttpServletRequestProcessor(httpRequest)));
        }
    }
}

