/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.okhttp;

import io.sentry.Breadcrumb;
import io.sentry.Hint;
import io.sentry.IScopes;
import io.sentry.ISpan;
import io.sentry.SentryDate;
import io.sentry.okhttp.SentryOkHttpUtils;
import io.sentry.transport.CurrentDateProvider;
import io.sentry.util.Platform;
import io.sentry.util.UrlUtils;
import io.sentry.util.network.NetworkRequestData;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\t\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J-\u0010\u001c\u001a\u00020\u001d2%\b\u0002\u0010\u001e\u001a\u001f\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b(\"\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001fJ5\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u00112%\b\u0002\u0010\u001e\u001a\u001f\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b(\"\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001fJ\u000e\u0010%\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u0011J\u000e\u0010&\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u000eJ\u0010\u0010'\u001a\u00020\u001d2\b\u0010(\u001a\u0004\u0018\u00010\u0011J\u0010\u0010)\u001a\u00020\u001d2\b\u0010*\u001a\u0004\u0018\u00010\u0019J\u0010\u0010+\u001a\u00020\u001d2\b\u0010,\u001a\u0004\u0018\u00010\u0011J\u000e\u0010-\u001a\u00020\u001d2\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010.\u001a\u00020\u001d2\u0006\u0010/\u001a\u000200J\u000e\u00101\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u000eJ\u000e\u00102\u001a\u00020\u001d2\u0006\u0010/\u001a\u000200R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lio/sentry/okhttp/SentryOkHttpEvent;", "", "scopes", "Lio/sentry/IScopes;", "request", "Lokhttp3/Request;", "(Lio/sentry/IScopes;Lokhttp3/Request;)V", "breadcrumb", "Lio/sentry/Breadcrumb;", "callSpan", "Lio/sentry/ISpan;", "getCallSpan$sentry_okhttp", "()Lio/sentry/ISpan;", "clientErrorResponse", "Lokhttp3/Response;", "eventDates", "", "", "Lio/sentry/SentryDate;", "isEventFinished", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isEventFinished$sentry_okhttp", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "method", "networkDetails", "Lio/sentry/util/network/NetworkRequestData;", "response", "url", "finish", "", "beforeFinish", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "span", "onEventFinish", "event", "onEventStart", "setClientErrorResponse", "setError", "errorMessage", "setNetworkDetails", "networkRequestData", "setProtocol", "protocolName", "setRequest", "setRequestBodySize", "byteCount", "", "setResponse", "setResponseBodySize", "sentry-okhttp"})
@SourceDebugExtension(value={"SMAP\nSentryOkHttpEvent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SentryOkHttpEvent.kt\nio/sentry/okhttp/SentryOkHttpEvent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,192:1\n1#2:193\n*E\n"})
public final class SentryOkHttpEvent {
    @NotNull
    private final IScopes scopes;
    @NotNull
    private final Request request;
    @NotNull
    private final Map<String, SentryDate> eventDates;
    @NotNull
    private final Breadcrumb breadcrumb;
    @Nullable
    private final ISpan callSpan;
    @Nullable
    private Response response;
    @Nullable
    private Response clientErrorResponse;
    @Nullable
    private NetworkRequestData networkDetails;
    @NotNull
    private final AtomicBoolean isEventFinished;
    @NotNull
    private String url;
    @NotNull
    private String method;

    /*
     * WARNING - void declaration
     */
    public SentryOkHttpEvent(@NotNull IScopes scopes, @NotNull Request request) {
        void $this$_init__u24lambda_u240;
        Breadcrumb breadcrumb;
        ISpan parentSpan;
        Intrinsics.checkNotNullParameter((Object)scopes, (String)"scopes");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.scopes = scopes;
        this.request = request;
        this.eventDates = new ConcurrentHashMap();
        this.isEventFinished = new AtomicBoolean(false);
        UrlUtils.UrlDetails urlDetails = UrlUtils.parse((String)this.request.url().toString());
        Intrinsics.checkNotNullExpressionValue((Object)urlDetails, (String)"parse(...)");
        UrlUtils.UrlDetails urlDetails2 = urlDetails;
        String string = urlDetails2.getUrlOrFallback();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrlOrFallback(...)");
        this.url = string;
        this.method = this.request.method();
        ISpan iSpan = parentSpan = Platform.isAndroid() ? (ISpan)this.scopes.getTransaction() : this.scopes.getSpan();
        ISpan iSpan2 = this.callSpan = iSpan != null ? iSpan.startChild("http.client") : null;
        Object object = iSpan2 != null ? iSpan2.getSpanContext() : null;
        if (object != null) {
            object.setOrigin("auto.http.okhttp");
        }
        Breadcrumb breadcrumb2 = breadcrumb = new Breadcrumb();
        SentryOkHttpEvent sentryOkHttpEvent = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.setType("http");
        $this$_init__u24lambda_u240.setCategory("http");
        $this$_init__u24lambda_u240.setData("http.start_timestamp", (Object)CurrentDateProvider.getInstance().getCurrentTimeMillis());
        sentryOkHttpEvent.breadcrumb = breadcrumb;
        this.setRequest(this.request);
    }

    @Nullable
    public final ISpan getCallSpan$sentry_okhttp() {
        return this.callSpan;
    }

    @NotNull
    public final AtomicBoolean isEventFinished$sentry_okhttp() {
        return this.isEventFinished;
    }

    public final void setRequest(@NotNull Request request) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            UrlUtils.UrlDetails urlDetails = UrlUtils.parse((String)request.url().toString());
            Intrinsics.checkNotNullExpressionValue((Object)urlDetails, (String)"parse(...)");
            UrlUtils.UrlDetails urlDetails2 = urlDetails;
            String string = urlDetails2.getUrlOrFallback();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrlOrFallback(...)");
            this.url = string;
            String host = request.url().host();
            String encodedPath = request.url().encodedPath();
            this.method = request.method();
            ISpan iSpan = this.callSpan;
            if (iSpan != null) {
                iSpan.setDescription(this.method + ' ' + this.url);
            }
            urlDetails2.applyToSpan(this.callSpan);
            this.breadcrumb.setData("host", (Object)host);
            this.breadcrumb.setData("path", (Object)encodedPath);
            if (urlDetails2.getUrl() != null) {
                String string2 = urlDetails2.getUrl();
                Intrinsics.checkNotNull((Object)string2);
                this.breadcrumb.setData("url", (Object)string2);
            }
            String string3 = this.method.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
            this.breadcrumb.setData("method", (Object)string3);
            if (urlDetails2.getQuery() != null) {
                String string4 = urlDetails2.getQuery();
                Intrinsics.checkNotNull((Object)string4);
                this.breadcrumb.setData("http.query", (Object)string4);
            }
            if (urlDetails2.getFragment() != null) {
                String string5 = urlDetails2.getFragment();
                Intrinsics.checkNotNull((Object)string5);
                this.breadcrumb.setData("http.fragment", (Object)string5);
            }
            ISpan iSpan2 = this.callSpan;
            if (iSpan2 != null) {
                iSpan2.setData("url", (Object)this.url);
            }
            ISpan iSpan3 = this.callSpan;
            if (iSpan3 != null) {
                iSpan3.setData("host", (Object)host);
            }
            ISpan iSpan4 = this.callSpan;
            if (iSpan4 != null) {
                iSpan4.setData("path", (Object)encodedPath);
            }
            ISpan iSpan5 = this.callSpan;
            if (iSpan5 == null) break block7;
            String string6 = this.method.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toUpperCase(...)");
            iSpan5.setData("http.request.method", (Object)string6);
        }
    }

    public final void setResponse(@NotNull Response response) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            this.response = response;
            this.breadcrumb.setData("protocol", (Object)response.protocol().name());
            this.breadcrumb.setData("status_code", (Object)response.code());
            ISpan iSpan = this.callSpan;
            if (iSpan != null) {
                iSpan.setData("protocol", (Object)response.protocol().name());
            }
            ISpan iSpan2 = this.callSpan;
            if (iSpan2 == null) break block1;
            iSpan2.setData("http.response.status_code", (Object)response.code());
        }
    }

    public final void setProtocol(@Nullable String protocolName) {
        block1: {
            if (protocolName == null) break block1;
            this.breadcrumb.setData("protocol", (Object)protocolName);
            ISpan iSpan = this.callSpan;
            if (iSpan != null) {
                iSpan.setData("protocol", (Object)protocolName);
            }
        }
    }

    public final void setRequestBodySize(long byteCount) {
        block1: {
            if (byteCount <= -1L) break block1;
            this.breadcrumb.setData("request_content_length", (Object)byteCount);
            ISpan iSpan = this.callSpan;
            if (iSpan != null) {
                iSpan.setData("http.request_content_length", (Object)byteCount);
            }
        }
    }

    public final void setResponseBodySize(long byteCount) {
        block1: {
            if (byteCount <= -1L) break block1;
            this.breadcrumb.setData("response_content_length", (Object)byteCount);
            ISpan iSpan = this.callSpan;
            if (iSpan != null) {
                iSpan.setData("http.response_content_length", (Object)byteCount);
            }
        }
    }

    public final void setClientErrorResponse(@NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.clientErrorResponse = response;
    }

    public final void setError(@Nullable String errorMessage) {
        block1: {
            if (errorMessage == null) break block1;
            this.breadcrumb.setData("error_message", (Object)errorMessage);
            ISpan iSpan = this.callSpan;
            if (iSpan != null) {
                iSpan.setData("error_message", (Object)errorMessage);
            }
        }
    }

    public final void setNetworkDetails(@Nullable NetworkRequestData networkRequestData) {
        this.networkDetails = networkRequestData;
    }

    public final void onEventStart(@NotNull String event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.callSpan == null) {
            return;
        }
        Map<String, SentryDate> map = this.eventDates;
        SentryDate sentryDate = this.scopes.getOptions().getDateProvider().now();
        Intrinsics.checkNotNullExpressionValue((Object)sentryDate, (String)"now(...)");
        SentryDate sentryDate2 = sentryDate;
        map.put(event, sentryDate2);
    }

    public final void onEventFinish(@NotNull String event, @Nullable Function1<? super ISpan, Unit> beforeFinish) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        SentryDate sentryDate = this.eventDates.remove(event);
        if (sentryDate == null) {
            return;
        }
        SentryDate eventDate = sentryDate;
        if (this.callSpan == null) {
            return;
        }
        Function1<? super ISpan, Unit> function1 = beforeFinish;
        if (function1 != null) {
            function1.invoke((Object)this.callSpan);
        }
        long eventDurationNanos = this.scopes.getOptions().getDateProvider().now().diff(eventDate);
        this.callSpan.setData(event, (Object)TimeUnit.NANOSECONDS.toMillis(eventDurationNanos));
    }

    public static /* synthetic */ void onEventFinish$default(SentryOkHttpEvent sentryOkHttpEvent, String string, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        sentryOkHttpEvent.onEventFinish(string, (Function1<? super ISpan, Unit>)function1);
    }

    public final void finish(@Nullable Function1<? super ISpan, Unit> beforeFinish) {
        block6: {
            Response it;
            if (this.isEventFinished.getAndSet(true)) {
                return;
            }
            this.eventDates.clear();
            Hint hint = new Hint();
            hint.set("okHttp:request", (Object)this.request);
            Response response = this.response;
            if (response != null) {
                it = response;
                boolean bl = false;
                hint.set("okHttp:response", (Object)it);
            }
            NetworkRequestData networkRequestData = this.networkDetails;
            if (networkRequestData != null) {
                it = networkRequestData;
                boolean bl = false;
                hint.set("sentry:replayNetworkDetails", (Object)it);
            }
            this.breadcrumb.setData("http.end_timestamp", (Object)CurrentDateProvider.getInstance().getCurrentTimeMillis());
            this.scopes.addBreadcrumb(this.breadcrumb, hint);
            ISpan iSpan = this.callSpan;
            if (iSpan != null) {
                it = iSpan;
                boolean bl = false;
                Function1<? super ISpan, Unit> function1 = beforeFinish;
                if (function1 != null) {
                    function1.invoke((Object)it);
                }
            }
            Response response2 = this.clientErrorResponse;
            if (response2 != null) {
                it = response2;
                boolean bl = false;
                SentryOkHttpUtils.INSTANCE.captureClientError$sentry_okhttp(this.scopes, it.request(), it);
            }
            ISpan iSpan2 = this.callSpan;
            if (iSpan2 == null) break block6;
            iSpan2.finish();
        }
    }

    public static /* synthetic */ void finish$default(SentryOkHttpEvent sentryOkHttpEvent, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        sentryOkHttpEvent.finish((Function1<? super ISpan, Unit>)function1);
    }
}

