/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.okhttp;

import io.sentry.HubAdapter;
import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.SentryDate;
import io.sentry.SpanStatus;
import io.sentry.okhttp.SentryOkHttpEvent;
import io.sentry.okhttp.SentryOkHttpEventListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.Connection;
import okhttp3.EventListener;
import okhttp3.Handshake;
import okhttp3.HttpUrl;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 N2\u00020\u0001:\u0001NB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0019\b\u0016\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\nB\u0019\b\u0016\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000bB6\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012%\b\u0002\u0010\f\u001a\u001f\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u0001\u0018\u00010\r\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0016H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0018\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J*\u0010\"\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J2\u0010)\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010*\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010+\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020-H\u0016J\u0018\u0010.\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020-H\u0016J&\u0010/\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u00100\u001a\u0002012\f\u00102\u001a\b\u0012\u0004\u0012\u00020403H\u0016J\u0018\u00105\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u00100\u001a\u000201H\u0016J&\u00106\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u00107\u001a\u0002082\f\u00109\u001a\b\u0012\u0004\u0012\u00020&03H\u0016J\u0018\u0010:\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u00107\u001a\u000208H\u0016J\u0018\u0010;\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0018\u0010?\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010@\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010A\u001a\u00020BH\u0016J\u0010\u0010C\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0018\u0010D\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010E\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0018\u0010F\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010G\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0016H\u0016J\u0010\u0010H\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0018\u0010I\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0016H\u0016J\u001a\u0010J\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u000e2\b\u0010K\u001a\u0004\u0018\u00010LH\u0016J\u0010\u0010M\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u000eH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010\f\u001a\u001f\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u0001\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lio/sentry/okhttp/SentryOkHttpEventListener;", "Lokhttp3/EventListener;", "()V", "originalEventListener", "(Lokhttp3/EventListener;)V", "originalEventListenerFactory", "Lokhttp3/EventListener$Factory;", "(Lokhttp3/EventListener$Factory;)V", "hub", "Lio/sentry/IHub;", "(Lio/sentry/IHub;Lokhttp3/EventListener;)V", "(Lio/sentry/IHub;Lokhttp3/EventListener$Factory;)V", "originalEventListenerCreator", "Lkotlin/Function1;", "Lokhttp3/Call;", "Lkotlin/ParameterName;", "name", "call", "(Lio/sentry/IHub;Lkotlin/jvm/functions/Function1;)V", "cacheConditionalHit", "", "cachedResponse", "Lokhttp3/Response;", "cacheHit", "response", "cacheMiss", "callEnd", "callFailed", "ioe", "Ljava/io/IOException;", "callStart", "canCreateEventSpan", "", "canceled", "connectEnd", "inetSocketAddress", "Ljava/net/InetSocketAddress;", "proxy", "Ljava/net/Proxy;", "protocol", "Lokhttp3/Protocol;", "connectFailed", "connectStart", "connectionAcquired", "connection", "Lokhttp3/Connection;", "connectionReleased", "dnsEnd", "domainName", "", "inetAddressList", "", "Ljava/net/InetAddress;", "dnsStart", "proxySelectEnd", "url", "Lokhttp3/HttpUrl;", "proxies", "proxySelectStart", "requestBodyEnd", "byteCount", "", "requestBodyStart", "requestFailed", "requestHeadersEnd", "request", "Lokhttp3/Request;", "requestHeadersStart", "responseBodyEnd", "responseBodyStart", "responseFailed", "responseHeadersEnd", "responseHeadersStart", "satisfactionFailure", "secureConnectEnd", "handshake", "Lokhttp3/Handshake;", "secureConnectStart", "Companion", "sentry-okhttp"})
public class SentryOkHttpEventListener
extends EventListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IHub hub;
    @Nullable
    private final Function1<Call, EventListener> originalEventListenerCreator;
    @Nullable
    private EventListener originalEventListener;
    @NotNull
    public static final String PROXY_SELECT_EVENT = "proxy_select";
    @NotNull
    public static final String DNS_EVENT = "dns";
    @NotNull
    public static final String SECURE_CONNECT_EVENT = "secure_connect";
    @NotNull
    public static final String CONNECT_EVENT = "connect";
    @NotNull
    public static final String CONNECTION_EVENT = "connection";
    @NotNull
    public static final String REQUEST_HEADERS_EVENT = "request_headers";
    @NotNull
    public static final String REQUEST_BODY_EVENT = "request_body";
    @NotNull
    public static final String RESPONSE_HEADERS_EVENT = "response_headers";
    @NotNull
    public static final String RESPONSE_BODY_EVENT = "response_body";
    @NotNull
    private static final Map<Call, SentryOkHttpEvent> eventMap = new ConcurrentHashMap();

    public SentryOkHttpEventListener(@NotNull IHub hub, @Nullable Function1<? super Call, ? extends EventListener> originalEventListenerCreator) {
        Intrinsics.checkNotNullParameter((Object)hub, (String)"hub");
        this.hub = hub;
        this.originalEventListenerCreator = originalEventListenerCreator;
    }

    public /* synthetic */ SentryOkHttpEventListener(IHub iHub, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            HubAdapter hubAdapter = HubAdapter.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)hubAdapter, (String)"getInstance()");
            iHub = (IHub)hubAdapter;
        }
        if ((n & 2) != 0) {
            function1 = null;
        }
        this(iHub, (Function1<? super Call, ? extends EventListener>)function1);
    }

    public SentryOkHttpEventListener() {
        HubAdapter hubAdapter = HubAdapter.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)hubAdapter, (String)"getInstance()");
        this((IHub)hubAdapter, (Function1<? super Call, ? extends EventListener>)null);
    }

    public SentryOkHttpEventListener(final @NotNull EventListener originalEventListener) {
        Intrinsics.checkNotNullParameter((Object)originalEventListener, (String)"originalEventListener");
        HubAdapter hubAdapter = HubAdapter.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)hubAdapter, (String)"getInstance()");
        this((IHub)hubAdapter, (Function1<? super Call, ? extends EventListener>)((Function1)new Function1<Call, EventListener>(){

            @NotNull
            public final EventListener invoke(@NotNull Call it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return originalEventListener;
            }
        }));
    }

    public SentryOkHttpEventListener(final @NotNull EventListener.Factory originalEventListenerFactory) {
        Intrinsics.checkNotNullParameter((Object)originalEventListenerFactory, (String)"originalEventListenerFactory");
        HubAdapter hubAdapter = HubAdapter.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)hubAdapter, (String)"getInstance()");
        this((IHub)hubAdapter, (Function1<? super Call, ? extends EventListener>)((Function1)new Function1<Call, EventListener>(){

            @NotNull
            public final EventListener invoke(@NotNull Call it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return originalEventListenerFactory.create(it);
            }
        }));
    }

    public SentryOkHttpEventListener(@NotNull IHub hub, final @NotNull EventListener originalEventListener) {
        Intrinsics.checkNotNullParameter((Object)hub, (String)"hub");
        Intrinsics.checkNotNullParameter((Object)originalEventListener, (String)"originalEventListener");
        this(hub, (Function1<? super Call, ? extends EventListener>)((Function1)new Function1<Call, EventListener>(){

            @NotNull
            public final EventListener invoke(@NotNull Call it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return originalEventListener;
            }
        }));
    }

    public /* synthetic */ SentryOkHttpEventListener(IHub iHub, EventListener eventListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            HubAdapter hubAdapter = HubAdapter.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)hubAdapter, (String)"getInstance()");
            iHub = (IHub)hubAdapter;
        }
        this(iHub, eventListener);
    }

    public SentryOkHttpEventListener(@NotNull IHub hub, final @NotNull EventListener.Factory originalEventListenerFactory) {
        Intrinsics.checkNotNullParameter((Object)hub, (String)"hub");
        Intrinsics.checkNotNullParameter((Object)originalEventListenerFactory, (String)"originalEventListenerFactory");
        this(hub, (Function1<? super Call, ? extends EventListener>)((Function1)new Function1<Call, EventListener>(){

            @NotNull
            public final EventListener invoke(@NotNull Call it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return originalEventListenerFactory.create(it);
            }
        }));
    }

    public /* synthetic */ SentryOkHttpEventListener(IHub iHub, EventListener.Factory factory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            HubAdapter hubAdapter = HubAdapter.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)hubAdapter, (String)"getInstance()");
            iHub = (IHub)hubAdapter;
        }
        this(iHub, factory);
    }

    public void callStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Function1<Call, EventListener> function1 = this.originalEventListenerCreator;
        EventListener eventListener = this.originalEventListener = function1 != null ? (EventListener)function1.invoke((Object)call) : null;
        if (eventListener != null) {
            eventListener.callStart(call);
        }
        if (this.canCreateEventSpan()) {
            eventMap.put(call, new SentryOkHttpEvent(this.hub, call.request()));
        }
    }

    public void proxySelectStart(@NotNull Call call, @NotNull HttpUrl url) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        EventListener eventListener = this.originalEventListener;
        if (eventListener != null) {
            eventListener.proxySelectStart(call, url);
        }
        if (!this.canCreateEventSpan()) {
            return;
        }
        SentryOkHttpEvent sentryOkHttpEvent = eventMap.get(call);
        if (sentryOkHttpEvent == null) {
            return;
        }
        SentryOkHttpEvent okHttpEvent = sentryOkHttpEvent;
        okHttpEvent.startSpan(PROXY_SELECT_EVENT);
    }

    public void proxySelectEnd(@NotNull Call call, @NotNull HttpUrl url, @NotNull List<? extends Proxy> proxies) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(proxies, (String)"proxies");
        EventListener eventListener = this.originalEventListener;
        if (eventListener != null) {
            eventListener.proxySelectEnd(call, url, proxies);
        }
        if (!this.canCreateEventSpan()) {
            return;
        }
        SentryOkHttpEvent sentryOkHttpEvent = eventMap.get(call);
        if (sentryOkHttpEvent == null) {
            return;
        }
        SentryOkHttpEvent okHttpEvent = sentryOkHttpEvent;
        okHttpEvent.finishSpan(PROXY_SELECT_EVENT, (Function1<? super ISpan, Unit>)((Function1)new Function1<ISpan, Unit>(proxies){
            final /* synthetic */ List<Proxy> $proxies;
            {
                this.$proxies = $proxies;
                super(1);
            }

            public final void invoke(@NotNull ISpan it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (!((Collection)this.$proxies).isEmpty()) {
                    it.setData("proxies", (Object)CollectionsKt.joinToString$default((Iterable)this.$proxies, null, null, null, (int)0, null, (Function1)proxySelectEnd.1.INSTANCE, (int)31, null));
                }
            }
        }));
    }

    public void dnsStart(@NotNull Call call, @NotNull String domainName) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)domainName, (String)"domainName");
        EventListener eventListener = this.originalEventListener;
        if (eventListener != null) {
            eventListener.dnsStart(call, domainName);
        }
        if (!this.canCreateEventSpan()) {
            return;
        }
        SentryOkHttpEvent sentryOkHttpEvent = eventMap.get(call);
        if (sentryOkHttpEvent == null) {
            return;
        }
        SentryOkHttpEvent okHttpEvent = sentryOkHttpEvent;
        okHttpEvent.startSpan(DNS_EVENT);
    }

    public void dnsEnd(@NotNull Call call, @NotNull String domainName, @NotNull List<? extends InetAddress> inetAddressList) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)domainName, (String)"domainName");
        Intrinsics.checkNotNullParameter(inetAddressList, (String)"inetAddressList");
        EventListener eventListener = this.originalEventListener;
        if (eventListener != null) {
            eventListener.dnsEnd(call, domainName, inetAddressList);
        }
        if (!this.canCreateEventSpan()) {
            return;
        }
        SentryOkHttpEvent sentryOkHttpEvent = eventMap.get(call);
        if (sentryOkHttpEvent == null) {
            return;
        }
        SentryOkHttpEvent okHttpEvent = sentryOkHttpEvent;
        okHttpEvent.finishSpan(DNS_EVENT, (Function1<? super ISpan, Unit>)((Function1)new Function1<ISpan, Unit>(domainName, inetAddressList){
            final /* synthetic */ String $domainName;
            final /* synthetic */ List<InetAddress> $inetAddressList;
            {
                this.$domainName = $domainName;
                this.$inetAddressList = $inetAddressList;
                super(1);
            }

            public final void invoke(@NotNull ISpan it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.setData("domain_name", (Object)this.$domainName);
                if (!((Collection)this.$inetAddressList).isEmpty()) {
                    it.setData("dns_addresses", (Object)CollectionsKt.joinToString$default((Iterable)this.$inetAddressList, null, null, null, (int)0, null, (Function1)dnsEnd.1.INSTANCE, (int)31, null));
                }
            }
        }));
    }

    public void connectStart(@NotNull Call call, @NotNull InetSocketAddress inetSocketAddress, @NotNull Proxy proxy) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)inetSocketAddress, (String)"inetSocketAddress");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        EventListener eventListener = this.originalEventListener;
        if (eventListener != null) {
            eventListener.connectStart(call, inetSocketAddress, proxy);
        }
        if (!this.canCreateEventSpan()) {
            return;
        }
        SentryOkHttpEvent sentryOkHttpEvent = eventMap.get(call);
        if (sentryOkHttpEvent == null) {
            return;
        }
        SentryOkHttpEvent okHttpEvent = sentryOkHttpEvent;
        okHttpEvent.startSpan(CONNECT_EVENT);
    }

    public void secureConnectStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        EventListener eventListener = this.originalEventListener;
        if (eventListener != null) {
            eventListener.secureConnectStart(call);
        }
        if (!this.canCreateEventSpan()) {
            return;
        }
        SentryOkHttpEvent sentryOkHttpEvent = eventMap.get(call);
        if (sentryOkHttpEvent == null) {
            return;
        }
        SentryOkHttpEvent okHttpEvent = sentryOkHttpEvent;
        okHttpEvent.startSpan(SECURE_CONNECT_EVENT);
    }

    public void secureConnectEnd(@NotNull Call call, @Nullable Handshake handshake) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        EventListener eventListener = this.originalEventListener;
        if (eventListener != null) {
            eventListener.secureConnectEnd(call, handshake);
        }
        if (!this.canCreateEventSpan()) {
            return;
        }
        SentryOkHttpEvent sentryOkHttpEvent = eventMap.get(call);
        if (sentryOkHttpEvent == null) {
            return;
        }
        SentryOkHttpEvent okHttpEvent = sentryOkHttpEvent;
        SentryOkHttpEvent.finishSpan$default(okHttpEvent, SECURE_CONNECT_EVENT, null, 2, null);
    }

    public void connectEnd(@NotNull Call call, @NotNull InetSocketAddress inetSocketAddress, @NotNull Proxy proxy, @Nullable Protocol protocol) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)inetSocketAddress, (String)"inetSocketAddress");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        EventListener eventListener = this.originalEventListener;
        if (eventListener != null) {
            eventListener.connectEnd(call, inetSocketAddress, proxy, protocol);
        }
        if (!this.canCreateEventSpan()) {
            return;
        }
        SentryOkHttpEvent sentryOkHttpEvent = eventMap.get(call);
        if (sentryOkHttpEvent == null) {
            return;
        }
        SentryOkHttpEvent okHttpEvent = sentryOkHttpEvent;
        Protocol protocol2 = protocol;
        okHttpEvent.setProtocol(protocol2 != null ? protocol2.name() : null);
        SentryOkHttpEvent.finishSpan$default(okHttpEvent, CONNECT_EVENT, null, 2, null);
    }

    public void connectFailed(@NotNull Call call, @NotNull InetSocketAddress inetSocketAddress, @NotNull Proxy proxy, @Nullable Protocol protocol, @NotNull IOException ioe) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)inetSocketAddress, (String)"inetSocketAddress");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
        EventListener eventListener = this.originalEventListener;
        if (eventListener != null) {
            eventListener.connectFailed(call, inetSocketAddress, proxy, protocol, ioe);
        }
        if (!this.canCreateEventSpan()) {
            return;
        }
        SentryOkHttpEvent sentryOkHttpEvent = eventMap.get(call);
        if (sentryOkHttpEvent == null) {
            return;
        }
        SentryOkHttpEvent okHttpEvent = sentryOkHttpEvent;
        Protocol protocol2 = protocol;
        okHttpEvent.setProtocol(protocol2 != null ? protocol2.name() : null);
        okHttpEvent.setError(ioe.getMessage());
        okHttpEvent.finishSpan(CONNECT_EVENT, (Function1<? super ISpan, Unit>)((Function1)new Function1<ISpan, Unit>(ioe){
            final /* synthetic */ IOException $ioe;
            {
                this.$ioe = $ioe;
                super(1);
            }

            public final void invoke(@NotNull ISpan it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.setThrowable((Throwable)this.$ioe);
                it.setStatus(SpanStatus.INTERNAL_ERROR);
            }
        }));
    }

    public void connectionAcquired(@NotNull Call call, @NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)connection, (String)CONNECTION_EVENT);
        EventListener eventListener = this.originalEventListener;
        if (eventListener != null) {
            eventListener.connectionAcquired(call, connection);
        }
        if (!this.canCreateEventSpan()) {
            return;
        }
        SentryOkHttpEvent sentryOkHttpEvent = eventMap.get(call);
        if (sentryOkHttpEvent == null) {
            return;
        }
        SentryOkHttpEvent okHttpEvent = sentryOkHttpEvent;
        okHttpEvent.startSpan(CONNECTION_EVENT);
    }

    public void connectionReleased(@NotNull Call call, @NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)connection, (String)CONNECTION_EVENT);
        EventListener eventListener = this.originalEventListener;
        if (eventListener != null) {
            eventListener.connectionReleased(call, connection);
        }
        if (!this.canCreateEventSpan()) {
            return;
        }
        SentryOkHttpEvent sentryOkHttpEvent = eventMap.get(call);
        if (sentryOkHttpEvent == null) {
            return;
        }
        SentryOkHttpEvent okHttpEvent = sentryOkHttpEvent;
        SentryOkHttpEvent.finishSpan$default(okHttpEvent, CONNECTION_EVENT, null, 2, null);
    }

    public void requestHeadersStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        EventListener eventListener = this.originalEventListener;
        if (eventListener != null) {
            eventListener.requestHeadersStart(call);
        }
        if (!this.canCreateEventSpan()) {
            return;
        }
        SentryOkHttpEvent sentryOkHttpEvent = eventMap.get(call);
        if (sentryOkHttpEvent == null) {
            return;
        }
        SentryOkHttpEvent okHttpEvent = sentryOkHttpEvent;
        okHttpEvent.startSpan(REQUEST_HEADERS_EVENT);
    }

    public void requestHeadersEnd(@NotNull Call call, @NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        EventListener eventListener = this.originalEventListener;
        if (eventListener != null) {
            eventListener.requestHeadersEnd(call, request);
        }
        if (!this.canCreateEventSpan()) {
            return;
        }
        SentryOkHttpEvent sentryOkHttpEvent = eventMap.get(call);
        if (sentryOkHttpEvent == null) {
            return;
        }
        SentryOkHttpEvent okHttpEvent = sentryOkHttpEvent;
        SentryOkHttpEvent.finishSpan$default(okHttpEvent, REQUEST_HEADERS_EVENT, null, 2, null);
    }

    public void requestBodyStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        EventListener eventListener = this.originalEventListener;
        if (eventListener != null) {
            eventListener.requestBodyStart(call);
        }
        if (!this.canCreateEventSpan()) {
            return;
        }
        SentryOkHttpEvent sentryOkHttpEvent = eventMap.get(call);
        if (sentryOkHttpEvent == null) {
            return;
        }
        SentryOkHttpEvent okHttpEvent = sentryOkHttpEvent;
        okHttpEvent.startSpan(REQUEST_BODY_EVENT);
    }

    public void requestBodyEnd(@NotNull Call call, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        EventListener eventListener = this.originalEventListener;
        if (eventListener != null) {
            eventListener.requestBodyEnd(call, byteCount);
        }
        if (!this.canCreateEventSpan()) {
            return;
        }
        SentryOkHttpEvent sentryOkHttpEvent = eventMap.get(call);
        if (sentryOkHttpEvent == null) {
            return;
        }
        SentryOkHttpEvent okHttpEvent = sentryOkHttpEvent;
        okHttpEvent.finishSpan(REQUEST_BODY_EVENT, (Function1<? super ISpan, Unit>)((Function1)new Function1<ISpan, Unit>(byteCount){
            final /* synthetic */ long $byteCount;
            {
                this.$byteCount = $byteCount;
                super(1);
            }

            public final void invoke(@NotNull ISpan it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (this.$byteCount > 0L) {
                    it.setData("http.request_content_length", (Object)this.$byteCount);
                }
            }
        }));
        okHttpEvent.setRequestBodySize(byteCount);
    }

    public void requestFailed(@NotNull Call call, @NotNull IOException ioe) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
        EventListener eventListener = this.originalEventListener;
        if (eventListener != null) {
            eventListener.requestFailed(call, ioe);
        }
        if (!this.canCreateEventSpan()) {
            return;
        }
        SentryOkHttpEvent sentryOkHttpEvent = eventMap.get(call);
        if (sentryOkHttpEvent == null) {
            return;
        }
        SentryOkHttpEvent okHttpEvent = sentryOkHttpEvent;
        okHttpEvent.setError(ioe.getMessage());
        okHttpEvent.finishSpan(REQUEST_HEADERS_EVENT, (Function1<? super ISpan, Unit>)((Function1)new Function1<ISpan, Unit>(ioe){
            final /* synthetic */ IOException $ioe;
            {
                this.$ioe = $ioe;
                super(1);
            }

            public final void invoke(@NotNull ISpan it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (!it.isFinished()) {
                    it.setStatus(SpanStatus.INTERNAL_ERROR);
                    it.setThrowable((Throwable)this.$ioe);
                }
            }
        }));
        okHttpEvent.finishSpan(REQUEST_BODY_EVENT, (Function1<? super ISpan, Unit>)((Function1)new Function1<ISpan, Unit>(ioe){
            final /* synthetic */ IOException $ioe;
            {
                this.$ioe = $ioe;
                super(1);
            }

            public final void invoke(@NotNull ISpan it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.setStatus(SpanStatus.INTERNAL_ERROR);
                it.setThrowable((Throwable)this.$ioe);
            }
        }));
    }

    public void responseHeadersStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        EventListener eventListener = this.originalEventListener;
        if (eventListener != null) {
            eventListener.responseHeadersStart(call);
        }
        if (!this.canCreateEventSpan()) {
            return;
        }
        SentryOkHttpEvent sentryOkHttpEvent = eventMap.get(call);
        if (sentryOkHttpEvent == null) {
            return;
        }
        SentryOkHttpEvent okHttpEvent = sentryOkHttpEvent;
        okHttpEvent.startSpan(RESPONSE_HEADERS_EVENT);
    }

    public void responseHeadersEnd(@NotNull Call call, @NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        EventListener eventListener = this.originalEventListener;
        if (eventListener != null) {
            eventListener.responseHeadersEnd(call, response);
        }
        if (!this.canCreateEventSpan()) {
            return;
        }
        SentryOkHttpEvent sentryOkHttpEvent = eventMap.get(call);
        if (sentryOkHttpEvent == null) {
            return;
        }
        SentryOkHttpEvent okHttpEvent = sentryOkHttpEvent;
        okHttpEvent.setResponse(response);
        ISpan responseHeadersSpan2 = okHttpEvent.finishSpan(RESPONSE_HEADERS_EVENT, (Function1<? super ISpan, Unit>)((Function1)new Function1<ISpan, Unit>(response){
            final /* synthetic */ Response $response;
            {
                this.$response = $response;
                super(1);
            }

            public final void invoke(@NotNull ISpan it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.setData("http.response.status_code", (Object)this.$response.code());
                if (it.getStatus() == null) {
                    it.setStatus(SpanStatus.fromHttpStatusCode((int)this.$response.code()));
                }
            }
        }));
        ISpan iSpan = responseHeadersSpan2;
        if (iSpan == null || (iSpan = iSpan.getFinishDate()) == null) {
            iSpan = this.hub.getOptions().getDateProvider().now();
        }
        Intrinsics.checkNotNullExpressionValue((Object)iSpan, (String)"responseHeadersSpan?.fin\u2026ptions.dateProvider.now()");
        okHttpEvent.scheduleFinish((SentryDate)iSpan);
    }

    public void responseBodyStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        EventListener eventListener = this.originalEventListener;
        if (eventListener != null) {
            eventListener.responseBodyStart(call);
        }
        if (!this.canCreateEventSpan()) {
            return;
        }
        SentryOkHttpEvent sentryOkHttpEvent = eventMap.get(call);
        if (sentryOkHttpEvent == null) {
            return;
        }
        SentryOkHttpEvent okHttpEvent = sentryOkHttpEvent;
        okHttpEvent.startSpan(RESPONSE_BODY_EVENT);
    }

    public void responseBodyEnd(@NotNull Call call, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        EventListener eventListener = this.originalEventListener;
        if (eventListener != null) {
            eventListener.responseBodyEnd(call, byteCount);
        }
        if (!this.canCreateEventSpan()) {
            return;
        }
        SentryOkHttpEvent sentryOkHttpEvent = eventMap.get(call);
        if (sentryOkHttpEvent == null) {
            return;
        }
        SentryOkHttpEvent okHttpEvent = sentryOkHttpEvent;
        okHttpEvent.setResponseBodySize(byteCount);
        okHttpEvent.finishSpan(RESPONSE_BODY_EVENT, (Function1<? super ISpan, Unit>)((Function1)new Function1<ISpan, Unit>(byteCount){
            final /* synthetic */ long $byteCount;
            {
                this.$byteCount = $byteCount;
                super(1);
            }

            public final void invoke(@NotNull ISpan it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (this.$byteCount > 0L) {
                    it.setData("http.response_content_length", (Object)this.$byteCount);
                }
            }
        }));
    }

    public void responseFailed(@NotNull Call call, @NotNull IOException ioe) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
        EventListener eventListener = this.originalEventListener;
        if (eventListener != null) {
            eventListener.responseFailed(call, ioe);
        }
        if (!this.canCreateEventSpan()) {
            return;
        }
        SentryOkHttpEvent sentryOkHttpEvent = eventMap.get(call);
        if (sentryOkHttpEvent == null) {
            return;
        }
        SentryOkHttpEvent okHttpEvent = sentryOkHttpEvent;
        okHttpEvent.setError(ioe.getMessage());
        okHttpEvent.finishSpan(RESPONSE_HEADERS_EVENT, (Function1<? super ISpan, Unit>)((Function1)new Function1<ISpan, Unit>(ioe){
            final /* synthetic */ IOException $ioe;
            {
                this.$ioe = $ioe;
                super(1);
            }

            public final void invoke(@NotNull ISpan it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (!it.isFinished()) {
                    it.setStatus(SpanStatus.INTERNAL_ERROR);
                    it.setThrowable((Throwable)this.$ioe);
                }
            }
        }));
        okHttpEvent.finishSpan(RESPONSE_BODY_EVENT, (Function1<? super ISpan, Unit>)((Function1)new Function1<ISpan, Unit>(ioe){
            final /* synthetic */ IOException $ioe;
            {
                this.$ioe = $ioe;
                super(1);
            }

            public final void invoke(@NotNull ISpan it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.setStatus(SpanStatus.INTERNAL_ERROR);
                it.setThrowable((Throwable)this.$ioe);
            }
        }));
    }

    public void callEnd(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        EventListener eventListener = this.originalEventListener;
        if (eventListener != null) {
            eventListener.callEnd(call);
        }
        SentryOkHttpEvent sentryOkHttpEvent = eventMap.remove(call);
        if (sentryOkHttpEvent == null) {
            return;
        }
        SentryOkHttpEvent okHttpEvent = sentryOkHttpEvent;
        SentryOkHttpEvent.finishEvent$default(okHttpEvent, null, null, 3, null);
    }

    public void callFailed(@NotNull Call call, @NotNull IOException ioe) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
        EventListener eventListener = this.originalEventListener;
        if (eventListener != null) {
            eventListener.callFailed(call, ioe);
        }
        if (!this.canCreateEventSpan()) {
            return;
        }
        SentryOkHttpEvent sentryOkHttpEvent = eventMap.remove(call);
        if (sentryOkHttpEvent == null) {
            return;
        }
        SentryOkHttpEvent okHttpEvent = sentryOkHttpEvent;
        okHttpEvent.setError(ioe.getMessage());
        SentryOkHttpEvent.finishEvent$default(okHttpEvent, null, (Function1)new Function1<ISpan, Unit>(ioe){
            final /* synthetic */ IOException $ioe;
            {
                this.$ioe = $ioe;
                super(1);
            }

            public final void invoke(@NotNull ISpan it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.setStatus(SpanStatus.INTERNAL_ERROR);
                it.setThrowable((Throwable)this.$ioe);
            }
        }, 1, null);
    }

    public void canceled(@NotNull Call call) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            EventListener eventListener = this.originalEventListener;
            if (eventListener == null) break block0;
            eventListener.canceled(call);
        }
    }

    public void satisfactionFailure(@NotNull Call call, @NotNull Response response) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            EventListener eventListener = this.originalEventListener;
            if (eventListener == null) break block0;
            eventListener.satisfactionFailure(call, response);
        }
    }

    public void cacheHit(@NotNull Call call, @NotNull Response response) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            EventListener eventListener = this.originalEventListener;
            if (eventListener == null) break block0;
            eventListener.cacheHit(call, response);
        }
    }

    public void cacheMiss(@NotNull Call call) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            EventListener eventListener = this.originalEventListener;
            if (eventListener == null) break block0;
            eventListener.cacheMiss(call);
        }
    }

    public void cacheConditionalHit(@NotNull Call call, @NotNull Response cachedResponse) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Intrinsics.checkNotNullParameter((Object)cachedResponse, (String)"cachedResponse");
            EventListener eventListener = this.originalEventListener;
            if (eventListener == null) break block0;
            eventListener.cacheConditionalHit(call, cachedResponse);
        }
    }

    private final boolean canCreateEventSpan() {
        return !(this.originalEventListener instanceof SentryOkHttpEventListener);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lio/sentry/okhttp/SentryOkHttpEventListener$Companion;", "", "()V", "CONNECTION_EVENT", "", "CONNECT_EVENT", "DNS_EVENT", "PROXY_SELECT_EVENT", "REQUEST_BODY_EVENT", "REQUEST_HEADERS_EVENT", "RESPONSE_BODY_EVENT", "RESPONSE_HEADERS_EVENT", "SECURE_CONNECT_EVENT", "eventMap", "", "Lokhttp3/Call;", "Lio/sentry/okhttp/SentryOkHttpEvent;", "getEventMap$sentry_okhttp", "()Ljava/util/Map;", "sentry-okhttp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<Call, SentryOkHttpEvent> getEventMap$sentry_okhttp() {
            return eventMap;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

