/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.encoder.Encoder;
import io.sentry.Breadcrumb;
import io.sentry.DateUtils;
import io.sentry.Hint;
import io.sentry.HubAdapter;
import io.sentry.ITransportFactory;
import io.sentry.Sentry;
import io.sentry.SentryEvent;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.exception.ExceptionMechanismException;
import io.sentry.protocol.Mechanism;
import io.sentry.protocol.Message;
import io.sentry.protocol.SdkVersion;
import io.sentry.util.CollectionUtils;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SentryAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    public static final String MECHANISM_TYPE = "LogbackSentryAppender";
    @NotNull
    private SentryOptions options = new SentryOptions();
    @Nullable
    private ITransportFactory transportFactory;
    @NotNull
    private Level minimumBreadcrumbLevel = Level.INFO;
    @NotNull
    private Level minimumEventLevel = Level.ERROR;
    @Nullable
    private Encoder<ILoggingEvent> encoder;

    public void start() {
        if (!Sentry.isEnabled()) {
            if (this.options.getDsn() == null || !this.options.getDsn().endsWith("_IS_UNDEFINED")) {
                this.options.setEnableExternalConfiguration(true);
                this.options.setSentryClientName("sentry.java.logback/7.20.1");
                this.options.setSdkVersion(this.createSdkVersion(this.options));
                Optional.ofNullable(this.transportFactory).ifPresent(arg_0 -> ((SentryOptions)this.options).setTransportFactory(arg_0));
                try {
                    Sentry.init((SentryOptions)this.options);
                }
                catch (IllegalArgumentException e) {
                    this.addWarn("Failed to init Sentry during appender initialization: " + e.getMessage());
                }
            } else {
                this.options.getLogger().log(SentryLevel.WARNING, "DSN is null. SentryAppender is not being initialized", new Object[0]);
            }
        }
        this.addPackageAndIntegrationInfo();
        super.start();
    }

    protected void append(@NotNull ILoggingEvent eventObject) {
        Hint hint;
        if (eventObject.getLevel().isGreaterOrEqual(this.minimumEventLevel)) {
            hint = new Hint();
            hint.set("syntheticException", (Object)eventObject);
            Sentry.captureEvent((SentryEvent)this.createEvent(eventObject), (Hint)hint);
        }
        if (eventObject.getLevel().isGreaterOrEqual(this.minimumBreadcrumbLevel)) {
            hint = new Hint();
            hint.set("logback:loggingEvent", (Object)eventObject);
            Sentry.addBreadcrumb((Breadcrumb)this.createBreadcrumb(eventObject), (Hint)hint);
        }
    }

    @NotNull
    protected SentryEvent createEvent(@NotNull ILoggingEvent loggingEvent) {
        Map mdcProperties;
        SentryEvent event = new SentryEvent(DateUtils.getDateTime((long)loggingEvent.getTimeStamp()));
        Message message = new Message();
        if (this.encoder == null || this.options.isSendDefaultPii()) {
            message.setMessage(loggingEvent.getMessage());
            message.setParams(this.toParams(loggingEvent.getArgumentArray()));
        }
        message.setFormatted(this.formatted(loggingEvent));
        event.setMessage(message);
        event.setLogger(loggingEvent.getLoggerName());
        event.setLevel(SentryAppender.formatLevel(loggingEvent.getLevel()));
        ThrowableProxy throwableInformation = (ThrowableProxy)loggingEvent.getThrowableProxy();
        if (throwableInformation != null) {
            Mechanism mechanism = new Mechanism();
            mechanism.setType(MECHANISM_TYPE);
            ExceptionMechanismException mechanismException = new ExceptionMechanismException(mechanism, throwableInformation.getThrowable(), Thread.currentThread());
            event.setThrowable((Throwable)mechanismException);
        }
        if (loggingEvent.getThreadName() != null) {
            event.setExtra("thread_name", (Object)loggingEvent.getThreadName());
        }
        if (loggingEvent.getMarker() != null) {
            event.setExtra("marker", (Object)loggingEvent.getMarker().toString());
        }
        if (!(mdcProperties = CollectionUtils.filterMapEntries((Map)loggingEvent.getMDCPropertyMap(), entry -> entry.getValue() != null)).isEmpty()) {
            List contextTags = HubAdapter.getInstance().getOptions().getContextTags();
            if (!contextTags.isEmpty()) {
                for (String contextTag : contextTags) {
                    if (!mdcProperties.containsKey(contextTag)) continue;
                    event.setTag(contextTag, (String)mdcProperties.get(contextTag));
                    mdcProperties.remove(contextTag);
                }
            }
            if (!mdcProperties.isEmpty()) {
                event.getContexts().put((Object)"MDC", (Object)mdcProperties);
            }
        }
        return event;
    }

    private String formatted(@NotNull ILoggingEvent loggingEvent) {
        if (this.encoder != null) {
            try {
                return new String(this.encoder.encode((Object)loggingEvent), StandardCharsets.UTF_8);
            }
            catch (Throwable t) {
                this.addWarn("Failed to encode logging event", t);
            }
        }
        return loggingEvent.getFormattedMessage();
    }

    @NotNull
    private List<String> toParams(@Nullable Object[] arguments) {
        if (arguments != null) {
            return Arrays.stream(arguments).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @NotNull
    protected Breadcrumb createBreadcrumb(@NotNull ILoggingEvent loggingEvent) {
        Breadcrumb breadcrumb = new Breadcrumb();
        breadcrumb.setLevel(SentryAppender.formatLevel(loggingEvent.getLevel()));
        breadcrumb.setCategory(loggingEvent.getLoggerName());
        breadcrumb.setMessage(this.formatted(loggingEvent));
        return breadcrumb;
    }

    @NotNull
    private static SentryLevel formatLevel(@NotNull Level level) {
        if (level.isGreaterOrEqual(Level.ERROR)) {
            return SentryLevel.ERROR;
        }
        if (level.isGreaterOrEqual(Level.WARN)) {
            return SentryLevel.WARNING;
        }
        if (level.isGreaterOrEqual(Level.INFO)) {
            return SentryLevel.INFO;
        }
        return SentryLevel.DEBUG;
    }

    @NotNull
    private SdkVersion createSdkVersion(@NotNull SentryOptions sentryOptions) {
        SdkVersion sdkVersion = sentryOptions.getSdkVersion();
        String name = "sentry.java.logback";
        String version = "7.20.1";
        sdkVersion = SdkVersion.updateSdkVersion((SdkVersion)sdkVersion, (String)"sentry.java.logback", (String)"7.20.1");
        return sdkVersion;
    }

    private void addPackageAndIntegrationInfo() {
        SentryIntegrationPackageStorage.getInstance().addPackage("maven:io.sentry:sentry-logback", "7.20.1");
        SentryIntegrationPackageStorage.getInstance().addIntegration("Logback");
    }

    public void setOptions(@Nullable SentryOptions options) {
        if (options != null) {
            this.options = options;
        }
    }

    public void setMinimumBreadcrumbLevel(@Nullable Level minimumBreadcrumbLevel) {
        if (minimumBreadcrumbLevel != null) {
            this.minimumBreadcrumbLevel = minimumBreadcrumbLevel;
        }
    }

    @NotNull
    public Level getMinimumBreadcrumbLevel() {
        return this.minimumBreadcrumbLevel;
    }

    public void setMinimumEventLevel(@Nullable Level minimumEventLevel) {
        if (minimumEventLevel != null) {
            this.minimumEventLevel = minimumEventLevel;
        }
    }

    @NotNull
    public Level getMinimumEventLevel() {
        return this.minimumEventLevel;
    }

    @ApiStatus.Internal
    void setTransportFactory(@Nullable ITransportFactory transportFactory) {
        this.transportFactory = transportFactory;
    }

    public void setEncoder(Encoder<ILoggingEvent> encoder) {
        this.encoder = encoder;
    }
}

