/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.jul;

import io.sentry.Breadcrumb;
import io.sentry.Hint;
import io.sentry.HubAdapter;
import io.sentry.Sentry;
import io.sentry.SentryEvent;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.exception.ExceptionMechanismException;
import io.sentry.protocol.Mechanism;
import io.sentry.protocol.Message;
import io.sentry.protocol.SdkVersion;
import io.sentry.util.CollectionUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.slf4j.MDC;

public class SentryHandler
extends Handler {
    public static final String MECHANISM_TYPE = "JulSentryHandler";
    public static final String THREAD_ID = "thread_id";
    private boolean printfStyle;
    @NotNull
    private Level minimumBreadcrumbLevel = Level.INFO;
    @NotNull
    private Level minimumEventLevel = Level.SEVERE;

    public SentryHandler() {
        this(new SentryOptions(), true);
    }

    public SentryHandler(@NotNull SentryOptions options) {
        this(options, true);
    }

    @TestOnly
    SentryHandler(@NotNull SentryOptions options, boolean configureFromLogManager) {
        this.setFilter(new DropSentryFilter());
        if (configureFromLogManager) {
            this.retrieveProperties();
        }
        if (!Sentry.isEnabled()) {
            options.setEnableExternalConfiguration(true);
            options.setSdkVersion(this.createSdkVersion(options));
            Sentry.init((SentryOptions)options);
        }
        this.addPackageAndIntegrationInfo();
    }

    @Override
    public void publish(@NotNull LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        try {
            Hint hint;
            if (record.getLevel().intValue() >= this.minimumEventLevel.intValue()) {
                hint = new Hint();
                hint.set("syntheticException", (Object)record);
                Sentry.captureEvent((SentryEvent)this.createEvent(record), (Hint)hint);
            }
            if (record.getLevel().intValue() >= this.minimumBreadcrumbLevel.intValue()) {
                hint = new Hint();
                hint.set("jul:logRecord", (Object)record);
                Sentry.addBreadcrumb((Breadcrumb)this.createBreadcrumb(record), (Hint)hint);
            }
        }
        catch (RuntimeException e) {
            this.reportError("An exception occurred while creating a new event in Sentry", e, 1);
        }
    }

    private void retrieveProperties() {
        String minimumEventLevel;
        LogManager manager = LogManager.getLogManager();
        String className = SentryHandler.class.getName();
        this.setPrintfStyle(Boolean.parseBoolean(manager.getProperty(className + ".printfStyle")));
        this.setLevel(this.parseLevelOrDefault(manager.getProperty(className + ".level")));
        String minimumBreadCrumbLevel = manager.getProperty(className + ".minimumBreadcrumbLevel");
        if (minimumBreadCrumbLevel != null) {
            this.setMinimumBreadcrumbLevel(this.parseLevelOrDefault(minimumBreadCrumbLevel));
        }
        if ((minimumEventLevel = manager.getProperty(className + ".minimumEventLevel")) != null) {
            this.setMinimumEventLevel(this.parseLevelOrDefault(minimumEventLevel));
        }
    }

    @Nullable
    private static SentryLevel formatLevel(@NotNull Level level) {
        if (level.intValue() >= Level.SEVERE.intValue()) {
            return SentryLevel.ERROR;
        }
        if (level.intValue() >= Level.WARNING.intValue()) {
            return SentryLevel.WARNING;
        }
        if (level.intValue() >= Level.INFO.intValue()) {
            return SentryLevel.INFO;
        }
        if (level.intValue() >= Level.ALL.intValue()) {
            return SentryLevel.DEBUG;
        }
        return null;
    }

    @NotNull
    private Level parseLevelOrDefault(@NotNull String levelName) {
        try {
            return Level.parse(levelName.trim());
        }
        catch (RuntimeException e) {
            return Level.WARNING;
        }
    }

    @NotNull
    private Breadcrumb createBreadcrumb(@NotNull LogRecord record) {
        Breadcrumb breadcrumb = new Breadcrumb();
        breadcrumb.setLevel(SentryHandler.formatLevel(record.getLevel()));
        breadcrumb.setCategory(record.getLoggerName());
        if (record.getParameters() != null) {
            try {
                breadcrumb.setMessage(this.formatMessage(record.getMessage(), record.getParameters()));
            }
            catch (RuntimeException e) {
                breadcrumb.setMessage(record.getMessage());
            }
        } else {
            breadcrumb.setMessage(record.getMessage());
        }
        return breadcrumb;
    }

    @NotNull
    SentryEvent createEvent(@NotNull LogRecord record) {
        Map mdcProperties;
        SentryEvent event = new SentryEvent(new Date(record.getMillis()));
        event.setLevel(SentryHandler.formatLevel(record.getLevel()));
        event.setLogger(record.getLoggerName());
        Message sentryMessage = new Message();
        sentryMessage.setParams(this.toParams(record.getParameters()));
        String message = record.getMessage();
        if (record.getResourceBundle() != null && record.getResourceBundle().containsKey(record.getMessage())) {
            message = record.getResourceBundle().getString(record.getMessage());
        }
        sentryMessage.setMessage(message);
        if (record.getParameters() != null) {
            try {
                sentryMessage.setFormatted(this.formatMessage(message, record.getParameters()));
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        event.setMessage(sentryMessage);
        Throwable throwable = record.getThrown();
        if (throwable != null) {
            Mechanism mechanism = new Mechanism();
            mechanism.setType(MECHANISM_TYPE);
            ExceptionMechanismException mechanismException = new ExceptionMechanismException(mechanism, throwable, Thread.currentThread());
            event.setThrowable((Throwable)mechanismException);
        }
        if ((mdcProperties = MDC.getMDCAdapter().getCopyOfContextMap()) != null && !(mdcProperties = CollectionUtils.filterMapEntries((Map)mdcProperties, entry -> entry.getValue() != null)).isEmpty()) {
            List contextTags = HubAdapter.getInstance().getOptions().getContextTags();
            if (!contextTags.isEmpty()) {
                for (String contextTag : contextTags) {
                    if (!mdcProperties.containsKey(contextTag)) continue;
                    event.setTag(contextTag, (String)mdcProperties.get(contextTag));
                    mdcProperties.remove(contextTag);
                }
            }
            if (!mdcProperties.isEmpty()) {
                event.getContexts().put((Object)"MDC", (Object)mdcProperties);
            }
        }
        event.setExtra(THREAD_ID, (Object)record.getThreadID());
        return event;
    }

    @NotNull
    private List<String> toParams(@Nullable Object[] arguments) {
        ArrayList<String> result = new ArrayList<String>();
        if (arguments != null) {
            for (Object argument : arguments) {
                if (argument == null) continue;
                result.add(argument.toString());
            }
        }
        return result;
    }

    @NotNull
    private String formatMessage(@NotNull String message, @Nullable Object[] parameters) {
        String formatted = this.printfStyle ? String.format(message, parameters) : MessageFormat.format(message, parameters);
        return formatted;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
        try {
            Sentry.close();
        }
        catch (RuntimeException e) {
            this.reportError("An exception occurred while closing the Sentry connection", e, 3);
        }
    }

    @NotNull
    private SdkVersion createSdkVersion(@NotNull SentryOptions sentryOptions) {
        SdkVersion sdkVersion = sentryOptions.getSdkVersion();
        String name = "sentry.java.jul";
        String version = "7.12.0";
        sdkVersion = SdkVersion.updateSdkVersion((SdkVersion)sdkVersion, (String)"sentry.java.jul", (String)"7.12.0");
        return sdkVersion;
    }

    private void addPackageAndIntegrationInfo() {
        SentryIntegrationPackageStorage.getInstance().addPackage("maven:io.sentry:sentry-jul", "7.12.0");
        SentryIntegrationPackageStorage.getInstance().addIntegration("Jul");
    }

    public void setPrintfStyle(boolean printfStyle) {
        this.printfStyle = printfStyle;
    }

    public void setMinimumBreadcrumbLevel(@Nullable Level minimumBreadcrumbLevel) {
        if (minimumBreadcrumbLevel != null) {
            this.minimumBreadcrumbLevel = minimumBreadcrumbLevel;
        }
    }

    @NotNull
    public Level getMinimumBreadcrumbLevel() {
        return this.minimumBreadcrumbLevel;
    }

    public void setMinimumEventLevel(@Nullable Level minimumEventLevel) {
        if (minimumEventLevel != null) {
            this.minimumEventLevel = minimumEventLevel;
        }
    }

    @NotNull
    public Level getMinimumEventLevel() {
        return this.minimumEventLevel;
    }

    public boolean isPrintfStyle() {
        return this.printfStyle;
    }

    private static final class DropSentryFilter
    implements Filter {
        private DropSentryFilter() {
        }

        @Override
        public boolean isLoggable(@NotNull LogRecord record) {
            String loggerName = record.getLoggerName();
            return loggerName == null || !loggerName.startsWith("io.sentry") || loggerName.startsWith("io.sentry.samples");
        }
    }
}

