/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.graphql;

import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherExceptionHandlerResult;
import io.sentry.HubAdapter;
import io.sentry.IHub;
import io.sentry.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class SentryDataFetcherExceptionHandler
implements DataFetcherExceptionHandler {
    @NotNull
    private final IHub hub;
    @NotNull
    private final DataFetcherExceptionHandler delegate;

    public SentryDataFetcherExceptionHandler(@NotNull IHub hub, @NotNull DataFetcherExceptionHandler delegate) {
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"hub is required");
        this.delegate = (DataFetcherExceptionHandler)Objects.requireNonNull((Object)delegate, (String)"delegate is required");
    }

    public SentryDataFetcherExceptionHandler(@NotNull DataFetcherExceptionHandler delegate) {
        this((IHub)HubAdapter.getInstance(), delegate);
    }

    public DataFetcherExceptionHandlerResult onException(@NotNull DataFetcherExceptionHandlerParameters handlerParameters) {
        this.hub.captureException(handlerParameters.getException(), (Object)handlerParameters);
        return this.delegate.onException(handlerParameters);
    }
}

