/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import io.sentry.core.SentryStackTraceFactory;
import io.sentry.core.protocol.SentryStackFrame;
import io.sentry.core.protocol.SentryStackTrace;
import io.sentry.core.protocol.SentryThread;
import io.sentry.core.util.Objects;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

final class SentryThreadFactory {
    @NotNull
    private final SentryStackTraceFactory sentryStackTraceFactory;
    private final boolean attachStacktrace;

    public SentryThreadFactory(@NotNull SentryStackTraceFactory sentryStackTraceFactory, boolean attachStacktrace) {
        this.sentryStackTraceFactory = Objects.requireNonNull(sentryStackTraceFactory, "The SentryStackTraceFactory is required.");
        this.attachStacktrace = attachStacktrace;
    }

    public SentryThreadFactory(@NotNull SentryStackTraceFactory sentryStackTraceFactory) {
        this(sentryStackTraceFactory, false);
    }

    @Nullable
    List<SentryThread> getCurrentThreads(@Nullable List<Long> mechanismThreadIds) {
        return this.getCurrentThreads(Thread.getAllStackTraces(), mechanismThreadIds);
    }

    @TestOnly
    @Nullable
    List<SentryThread> getCurrentThreads(@NotNull Map<Thread, StackTraceElement[]> threads, @Nullable List<Long> mechanismThreadIds) {
        ArrayList<SentryThread> result = null;
        Thread currentThread = Thread.currentThread();
        if (threads.size() > 0) {
            result = new ArrayList<SentryThread>();
            if (!threads.containsKey(currentThread)) {
                threads.put(currentThread, currentThread.getStackTrace());
            }
            for (Map.Entry<Thread, StackTraceElement[]> item : threads.entrySet()) {
                Thread thread = item.getKey();
                boolean crashed = thread == currentThread || mechanismThreadIds != null && mechanismThreadIds.contains(thread.getId());
                result.add(this.getSentryThread(crashed, item.getValue(), item.getKey()));
            }
        }
        return result;
    }

    @NotNull
    private SentryThread getSentryThread(boolean crashed, @NotNull StackTraceElement[] stackFramesElements, @NotNull Thread thread) {
        SentryThread sentryThread = new SentryThread();
        sentryThread.setName(thread.getName());
        sentryThread.setPriority(thread.getPriority());
        sentryThread.setId(thread.getId());
        sentryThread.setDaemon(thread.isDaemon());
        sentryThread.setState(thread.getState().name());
        sentryThread.setCrashed(crashed);
        List<SentryStackFrame> frames = this.sentryStackTraceFactory.getStackFrames(stackFramesElements);
        if (this.attachStacktrace && frames != null && frames.size() > 0) {
            sentryThread.setStacktrace(new SentryStackTrace(frames));
        }
        return sentryThread;
    }
}

