/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import io.sentry.core.EventProcessor;
import io.sentry.core.SentryEvent;
import io.sentry.core.SentryExceptionFactory;
import io.sentry.core.SentryLevel;
import io.sentry.core.SentryOptions;
import io.sentry.core.SentryStackTraceFactory;
import io.sentry.core.SentryThreadFactory;
import io.sentry.core.protocol.SentryException;
import io.sentry.core.util.ApplyScopeUtils;
import io.sentry.core.util.Objects;
import java.util.ArrayList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class MainEventProcessor
implements EventProcessor {
    private final SentryOptions options;
    private final SentryThreadFactory sentryThreadFactory;
    private final SentryExceptionFactory sentryExceptionFactory;

    MainEventProcessor(SentryOptions options) {
        this.options = Objects.requireNonNull(options, "The SentryOptions is required.");
        SentryStackTraceFactory sentryStackTraceFactory = new SentryStackTraceFactory(options.getInAppExcludes(), options.getInAppIncludes());
        this.sentryExceptionFactory = new SentryExceptionFactory(sentryStackTraceFactory);
        this.sentryThreadFactory = new SentryThreadFactory(sentryStackTraceFactory, this.options.isAttachStacktrace());
    }

    MainEventProcessor(SentryOptions options, SentryThreadFactory sentryThreadFactory, SentryExceptionFactory sentryExceptionFactory) {
        this.options = Objects.requireNonNull(options, "The SentryOptions is required.");
        this.sentryThreadFactory = Objects.requireNonNull(sentryThreadFactory, "The SentryThreadFactory is required.");
        this.sentryExceptionFactory = Objects.requireNonNull(sentryExceptionFactory, "The SentryExceptionFactory is required.");
    }

    @Override
    public SentryEvent process(SentryEvent event, @Nullable Object hint) {
        Throwable throwable;
        if (event.getPlatform() == null) {
            event.setPlatform("java");
        }
        if ((throwable = event.getThrowable()) != null) {
            event.setExceptions(this.sentryExceptionFactory.getSentryExceptions(throwable));
        }
        if (ApplyScopeUtils.shouldApplyScopeData(hint)) {
            this.processNonCachedEvent(event);
        } else {
            this.options.getLogger().log(SentryLevel.DEBUG, "Event was cached so not applying data relevant to the current app execution/version: %s", event.getEventId());
        }
        return event;
    }

    private void processNonCachedEvent(SentryEvent event) {
        if (event.getRelease() == null) {
            event.setRelease(this.options.getRelease());
        }
        if (event.getEnvironment() == null) {
            event.setEnvironment(this.options.getEnvironment());
        }
        if (event.getServerName() == null) {
            event.setServerName(this.options.getServerName());
        }
        if (event.getDist() == null) {
            event.setDist(this.options.getDist());
        }
        if (event.getSdk() == null) {
            event.setSdk(this.options.getSdkVersion());
        }
        if (event.getThreads() == null && this.options.isAttachThreads()) {
            ArrayList<Long> mechanismThreadIds = null;
            if (event.getExceptions() != null) {
                for (SentryException item : event.getExceptions()) {
                    if (item.getMechanism() == null || item.getThreadId() == null) continue;
                    if (mechanismThreadIds == null) {
                        mechanismThreadIds = new ArrayList<Long>();
                    }
                    mechanismThreadIds.add(item.getThreadId());
                }
            }
            event.setThreads(this.sentryThreadFactory.getCurrentThreads(mechanismThreadIds));
        }
    }
}

