/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import io.sentry.core.IHub;
import io.sentry.core.SendCachedEvent;
import io.sentry.core.SendCachedEventFireAndForgetIntegration;
import io.sentry.core.SentryLevel;
import io.sentry.core.SentryOptions;
import java.io.File;
import org.jetbrains.annotations.NotNull;

final class SendFireAndForgetEventSender
implements SendCachedEventFireAndForgetIntegration.SendFireAndForgetFactory {
    @NotNull
    private final SendCachedEventFireAndForgetIntegration.SendFireAndForgetDirPath sendFireAndForgetDirPath;

    SendFireAndForgetEventSender(@NotNull SendCachedEventFireAndForgetIntegration.SendFireAndForgetDirPath sendFireAndForgetDirPath) {
        this.sendFireAndForgetDirPath = sendFireAndForgetDirPath;
    }

    @Override
    public SendCachedEventFireAndForgetIntegration.SendFireAndForget create(@NotNull IHub hub, @NotNull SentryOptions options) {
        String dirPath = this.sendFireAndForgetDirPath.getDirPath();
        if (dirPath == null) {
            options.getLogger().log(SentryLevel.WARNING, "No cache dir path is defined in options, discarding SendCachedEvent.", new Object[0]);
            return null;
        }
        SendCachedEvent sender = new SendCachedEvent(options.getSerializer(), hub, options.getLogger(), options.getFlushTimeoutMillis());
        File dirFile = new File(dirPath);
        return () -> {
            options.getLogger().log(SentryLevel.DEBUG, "Started processing cached files from %s", dirPath);
            sender.processDirectory(dirFile);
            options.getLogger().log(SentryLevel.DEBUG, "Finished processing cached files from %s", dirPath);
        };
    }
}

