/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import io.sentry.core.IHub;
import io.sentry.core.Integration;
import io.sentry.core.SentryLevel;
import io.sentry.core.SentryOptions;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.NotNull;

public final class SendCachedEventFireAndForgetIntegration
implements Integration {
    private final SendFireAndForgetFactory factory;

    public SendCachedEventFireAndForgetIntegration(SendFireAndForgetFactory factory) {
        this.factory = factory;
    }

    @Override
    public final void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        String cachedDir = options.getCacheDirPath();
        if (cachedDir == null) {
            options.getLogger().log(SentryLevel.WARNING, "No cache dir path is defined in options to SendCachedEventFireAndForgetIntegration.", new Object[0]);
            return;
        }
        SendFireAndForget sender = this.factory.create(hub, options);
        try {
            ExecutorService es = Executors.newSingleThreadExecutor();
            es.submit(() -> {
                try {
                    sender.send();
                    options.getLogger().log(SentryLevel.DEBUG, "Finished processing cached files from %s", cachedDir);
                }
                catch (Exception e) {
                    options.getLogger().log(SentryLevel.ERROR, "Failed trying to send cached events.", e);
                }
            });
            options.getLogger().log(SentryLevel.DEBUG, "Scheduled sending cached files from %s", cachedDir);
            es.shutdown();
            options.getLogger().log(SentryLevel.DEBUG, "SendCachedEventFireAndForgetIntegration installed.", new Object[0]);
        }
        catch (Exception e) {
            options.getLogger().log(SentryLevel.ERROR, "Failed to call the executor. Cached events will not be sent", e);
        }
    }

    public static interface SendFireAndForgetFactory {
        public SendFireAndForget create(IHub var1, SentryOptions var2);
    }

    public static interface SendFireAndForget {
        public void send();
    }
}

