/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class DateUtils {
    private static final String UTC = "UTC";
    private static final String ISO_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String ISO_FORMAT_WITH_MILLIS = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";

    private DateUtils() {
    }

    public static String getTimestampIsoFormat(Date date) {
        TimeZone tz = TimeZone.getTimeZone(UTC);
        SimpleDateFormat df = new SimpleDateFormat(ISO_FORMAT_WITH_MILLIS, Locale.US);
        df.setTimeZone(tz);
        return df.format(date);
    }

    public static Date getCurrentDateTime() {
        String timestampIsoFormat = DateUtils.getTimestampIsoFormat(new Date());
        return DateUtils.getDateTime(timestampIsoFormat);
    }

    public static Date getDateTime(String timestamp) throws IllegalArgumentException {
        try {
            return new SimpleDateFormat(ISO_FORMAT_WITH_MILLIS, Locale.US).parse(timestamp);
        }
        catch (ParseException e) {
            try {
                return new SimpleDateFormat(ISO_FORMAT, Locale.US).parse(timestamp);
            }
            catch (ParseException parseException) {
                throw new IllegalArgumentException("timestamp is not ISO format " + timestamp);
            }
        }
    }

    public static Date getDateTimeWithMillisPrecision(String timestamp) throws IllegalArgumentException {
        try {
            String[] times = timestamp.split("\\.", -1);
            long seconds = Long.parseLong(times[0]);
            long millis = times.length > 1 ? Long.parseLong(times[1]) : 0L;
            return new Date(seconds * 1000L + millis);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("timestamp is not millis format " + timestamp);
        }
    }

    public static String getTimestamp(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(ISO_FORMAT_WITH_MILLIS, Locale.US);
        return df.format(date);
    }

    public static Date getDateTime(Date date) {
        String timestampIsoFormat = DateUtils.getTimestampIsoFormat(date);
        return DateUtils.getDateTime(timestampIsoFormat);
    }
}

